<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);
ini_set('display_errors', '1');


require_once ("../database/sqlite.php");
require_once ("../database/sqliteinjection.php");
require_once ("../database/bibles.php");
require_once ("../database/bibles2.php");
require_once ("../database/books.php");


$database_bibles2 = Database_Bibles2::getInstance ();
$database_bibles2->create ();


$database_bibles = Database_Bibles::getInstance ();
$bibles = $database_bibles->getBibles ();
if (empty ($bibles)) {
  $bibles = $database_bibles2->getBibles ();
  foreach ($bibles as $bible) {
    $id = $database_bibles2->getID ($bible);
    $database_bibles->createBible ($bible);
    $database_bibles->setID ($bible, $id);
    $books = $database_bibles2->getBooks ($bible);
    foreach ($books as $book) {
      $chapters = $database_bibles2->getChapters ($bible, $book);
      foreach ($chapters as $chapter) {
        $data = $database_bibles2->getChapter ($bible, $book, $chapter);
        $database_bibles->storeChapterBare ($bible, $book, $chapter, $data);
      }
    }
  }
}


?>
