/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import jolon.xml.CDATA;
import jolon.xml.XMLObject;
import jolon.xml.XMLParser;

public abstract class GoBibleCreator {
    public static final String SUB_VERSION = "4.0";
    public static final char STYLE_RED = '\u0001';
    public static final String NAME_APPENDAGE = " Go Bible";
    public static final boolean COMBINED_CHAPTERS = true;
    public static final int MAX_FILE_SIZE_MIDP_2 = 24576;
    public static final int MAX_FILE_SIZE_MIDP_1 = 4096;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final String[] ALIGN_TEXT = new String[]{"Left", "Right"};
    public static final String UI_PROPERTIES_FILE_NAME = "ui.properties";
    public static String midpVersion = "MIDP-2.0";
    public static String versionString = "2.4.0";
    public static int MAX_FILE_SIZE = 24576;
    protected static boolean updateOnly = false;
    protected static String wapSite = null;
    protected static String midlet_infoURL = null;
    protected static String midlet_vendor = null;
    protected static String infoString = null;
    protected static String customFontString = null;
    protected static int align = 0;
    protected static String languageCode = "";
    protected static languageCodePositionType languageCodePosition;
    protected static HashMap uiProperties;
    protected static Vector<String> bookNames;
    protected static String baseSourceDirectory;
    protected static String usfmSourceFileExtension;
    protected static String phoneIconFilepath;
    protected static String fileCodepage;
    protected static String applicationName;
    protected static boolean useRedLettering;
    protected static String sTitleTag;
    protected static SourceFormatType sourceFormatType;
    protected static String EmptyVerseString;

    public static void main(String[] args) throws IOException {
        System.out.println("----------------------------------");
        System.out.println("GoBibleCreator Version: " + versionString);
        System.out.println("----------------------------------");
        if (args.length < 1) {
            System.out.println("Usage: java -jar CollectionsFilePath");
        } else {
            boolean baseSourceDirectoryFlag = false;
            for (String arg : args) {
                if (arg.compareToIgnoreCase("-dh") == 0) {
                    String[] properties = new String[]{"java.version", "java.vendor", "java.class.path", "os.name", "os.arch", "os.version", "user.dir"};
                    System.out.println("***************************************************");
                    System.out.println("*** Listing some debug type information here:");
                    try {
                        for (int i = 0; i < properties.length; ++i) {
                            System.out.println("*** " + properties[i] + " ==> " + System.getProperty(properties[i]));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    System.out.println("***************************************************");
                    System.out.println();
                    continue;
                }
                if (arg.equals("-u")) {
                    updateOnly = true;
                    System.out.println(" ** The \"Update-only\"(-u) flag has been found: updating the JAR/JAD files.");
                    System.out.println(" ** The original JAR files[s] are renamed with the file extension .TMP");
                    continue;
                }
                if (arg.equals("-d")) {
                    baseSourceDirectoryFlag = true;
                    System.out.println(" ** The \"Directory\"(-d) flag has been found.");
                    continue;
                }
                if (baseSourceDirectoryFlag) {
                    baseSourceDirectory = arg;
                    baseSourceDirectoryFlag = false;
                    System.out.println(" ** Using <" + baseSourceDirectory + "> as the base Source Directory.");
                    continue;
                }
                if (arg.toLowerCase().endsWith(".xml") || arg.toLowerCase().endsWith(".thm") || arg.toLowerCase().endsWith(".thml")) {
                    File xmlFile = new File(args[0]);
                    HashMap books = GoBibleCreator.parseXml(xmlFile);
                    if (books == null) continue;
                    GoBibleCreator.generateCollectionsFile(new File(xmlFile.getParent(), "Collections.txt"), xmlFile.getName(), books);
                    continue;
                }
                GoBibleCreator.create(new File(arg));
            }
        }
    }

    private static void UpdateBaseSourceDirectory(File collectionsFile) {
        if (baseSourceDirectory == null) {
            baseSourceDirectory = collectionsFile.getAbsolutePath();
            baseSourceDirectory = baseSourceDirectory.substring(0, baseSourceDirectory.length() - collectionsFile.getName().length());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void create(File collectionsFile) throws IOException {
        HashMap books = null;
        if (!updateOnly) {
            String sourceTextPath = GoBibleCreator.extractSourceTextPath(collectionsFile);
            sourceFormatType = GoBibleCreator.extractSourceFormatType(collectionsFile);
            if (sourceFormatType.equals((Object)SourceFormatType.unknown)) {
                sourceFormatType = GoBibleCreator.SourceFormatTypeRetry(baseSourceDirectory, sourceTextPath);
            }
            GoBibleCreator.UpdateBaseSourceDirectory(collectionsFile);
            if (sourceFormatType == SourceFormatType.osis || sourceFormatType == SourceFormatType.thml) {
                File xmlFile = new File(baseSourceDirectory, sourceTextPath);
                books = GoBibleCreator.parseXml(xmlFile);
            } else {
                if (sourceFormatType != SourceFormatType.usfm) {
                    System.out.println("Error: Could not determine Bible format type, " + (Object)((Object)sourceFormatType) + ".  Please use the 'Source-Format'");
                    System.out.println("property in your collections file.");
                    return;
                }
                GoBibleCreator.extractCommonFields(collectionsFile);
                GoBibleCreator.extractUSFMfields(collectionsFile);
                books = GoBibleCreator.parseUSFM(baseSourceDirectory, sourceTextPath, sTitleTag);
            }
        } else {
            GoBibleCreator.UpdateBaseSourceDirectory(collectionsFile);
        }
        if (books != null || updateOnly) {
            GoBibleCreator.parseUiProperties();
            Vector collections = GoBibleCreator.parseCollectionsFile(collectionsFile, books);
            if (customFontString != null) {
                GoBibleCreator.generateCustomFont(customFontString, collectionsFile, books);
            }
            String goBibleJarFileName = "GoBibleCore/GoBibleCore2.jar";
            File jarDirectory = GoBibleCreator.getJarDirectory();
            File jarFile = new File(jarDirectory, goBibleJarFileName);
            JarFile goBibleJar = new JarFile(jarFile);
            GoBibleCreator.writeCollections(collectionsFile.getParentFile(), collections, books, goBibleJar);
        }
    }

    public static File getJarDirectory() {
        String[] paths;
        String classPath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        for (String path : paths = classPath.split(pathSeparator)) {
            if (!path.contains("GoBibleCreator.jar")) continue;
            File file = new File(path);
            return file.getParentFile();
        }
        System.out.println("Error: couldn't find the path to GoBibleCreator.jar");
        return null;
    }

    public static String extractSourceTextPath(File collectionsFile) throws IOException {
        String sourceTextPath = null;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(collectionsFile), "UTF-8"));
        String line = null;
        String sourceTextPropertyName = "Source-Text:";
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith(sourceTextPropertyName)) continue;
            sourceTextPath = line.substring(sourceTextPropertyName.length()).trim();
            break;
        }
        reader.close();
        if (sourceTextPath == null) {
            System.err.println("Error parsing collections file: No Source-Text specified.");
            System.err.println("The source text is either a ThML or OSIS XML file.");
            System.err.println("It must be specified as follows:");
            System.err.println("Source-Text: Source.xml");
            System.err.println("For example:");
            System.err.println("Source-Text: kjv.thml");
        }
        return sourceTextPath;
    }

    public static SourceFormatType extractSourceFormatType(File collectionsFile) throws IOException {
        SourceFormatType srcFormatType = SourceFormatType.unknown;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(collectionsFile), "UTF-8"));
        String line = null;
        String sourceTextPropertyName = "Source-Format:";
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith(sourceTextPropertyName)) continue;
            String sFormat = line.substring(sourceTextPropertyName.length()).trim().toLowerCase();
            srcFormatType = sFormat.equals("osis") ? SourceFormatType.osis : (sFormat.equals("thml") ? SourceFormatType.thml : (sFormat.equals("usfm") ? SourceFormatType.usfm : SourceFormatType.unknown));
            break;
        }
        reader.close();
        return srcFormatType;
    }

    public static void extractUSFMfields(File collectionsFile) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(collectionsFile), "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Source-FileExtension:")) {
                usfmSourceFileExtension = line.substring("Source-FileExtension:".length()).trim().toLowerCase();
                usfmSourceFileExtension = usfmSourceFileExtension.replaceAll("\\.", "");
            }
            if (line.startsWith("USFM-TitleTag:")) {
                sTitleTag = line.substring("USFM-TitleTag:".length()).trim().toLowerCase();
            }
            if (!line.startsWith("RedLettering:") || line.toLowerCase().indexOf("false") <= 0 && line.toLowerCase().indexOf("no") <= 0) continue;
            useRedLettering = false;
        }
        reader.close();
    }

    public static void extractCommonFields(File collectionsFile) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(collectionsFile), "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("RedLettering:")) {
                if (line.toLowerCase().indexOf("false") <= 0 && line.toLowerCase().indexOf("no") <= 0) continue;
                useRedLettering = false;
                continue;
            }
            if (!line.startsWith("Empty-Verse-Text:")) continue;
            EmptyVerseString = line.substring(17).trim();
        }
        reader.close();
    }

    public static SourceFormatType SourceFormatTypeRetry(String baseSourceDirectory, String sourceTextPath) throws IOException {
        SourceFormatType srcFormatType = SourceFormatType.unknown;
        try {
            String lineIn;
            File fIn = new File(baseSourceDirectory, sourceTextPath);
            BufferedReader readerIn = new BufferedReader(new FileReader(fIn));
            for (int iRowCount = 0; (lineIn = readerIn.readLine()) != null || iRowCount < 200; ++iRowCount) {
                if ((lineIn = lineIn.toLowerCase()).indexOf("osis".toLowerCase()) > 0) {
                    srcFormatType = SourceFormatType.osis;
                    break;
                }
                if (lineIn.indexOf("ThML".toLowerCase()) <= 0) continue;
                srcFormatType = SourceFormatType.thml;
                break;
            }
            readerIn.close();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
        return srcFormatType;
    }

    public static HashMap parseXml(File xmlFile) throws IOException {
        System.out.println("Parsing " + xmlFile.getName() + "...");
        XMLObject xml = XMLParser.parseFile(xmlFile);
        System.out.println("Parsing " + xmlFile.getName() + " complete.");
        XMLObject parent = xml.getChild("osis");
        GoBibleCreator creator = null;
        if (parent != null) {
            System.out.println("Converting " + xmlFile.getName() + " from OSIS format.");
            creator = new OsisConverter();
        } else {
            System.out.println("Converting " + xmlFile.getName() + " from ThML format.");
            parent = xml.getChild("ThML");
            Enumeration e = xml.getChildren();
            while (e.hasMoreElements()) {
                XMLObject child = (XMLObject)e.nextElement();
            }
            if (parent != null) {
                creator = new ThmlConverter();
            } else {
                System.out.println("Error: XML file does not contain OSIS or ThML content: " + xmlFile.getName());
                return null;
            }
        }
        HashMap books = ((GoBibleCreator)creator).parse(parent);
        return books;
    }

    public static HashMap parseUSFM(String baseSourceDirectory, String sourceTextPath, String sTitleTag) throws IOException {
        HashMap<String, Book> books = new HashMap<String, Book>();
        if (baseSourceDirectory == null) {
            baseSourceDirectory = "";
        }
        try {
            System.out.println("Base Dir: " + baseSourceDirectory);
            System.out.println("Source Path: " + sourceTextPath);
            File folder = new File(baseSourceDirectory, sourceTextPath);
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                String sFileName;
                if (!listOfFiles[i].isFile() || !(sFileName = listOfFiles[i].getName()).toLowerCase().endsWith("." + usfmSourceFileExtension)) continue;
                System.out.println("File " + listOfFiles[i].getName());
                String sFilename = folder.toString() + "\\" + listOfFiles[i].getName();
                Book book = new Book(sFilename, '\u0001', fileCodepage, useRedLettering, sTitleTag);
                book.fileName = listOfFiles[i].getName();
                try {
                    books.put(book.name, book);
                }
                catch (Exception e) {
                    System.out.println("Error: " + e.getMessage());
                }
                bookNames.add(book.name);
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
        return books;
    }

    public static void generateCollectionsFile(File collectionsFile, String xmlFileName, HashMap books) throws IOException {
        System.out.println("No Collections file specified, generating: " + collectionsFile.getPath());
        PrintWriter writer = new PrintWriter(new FileWriter(collectionsFile));
        int dotIndex = xmlFileName.lastIndexOf(46);
        String collectionName = xmlFileName;
        if (dotIndex > 0) {
            collectionName = collectionName.substring(0, dotIndex);
        }
        writer.println("Collection: " + collectionName);
        for (String bookName : bookNames) {
            writer.println("Book: " + bookName);
        }
        writer.close();
        System.out.println("Collections file generated.");
    }

    public HashMap parseBooks(XMLObject xml, String bodyTag, String[] testamentTags, String bookTag, String primaryBookNameAttribute, String secondaryBookNameAttribute) {
        HashMap<String, Book> books = new HashMap<String, Book>();
        int numBooksWithOutVerses = 0;
        XMLObject body = xml.getChild(bodyTag);
        Enumeration t = body.getChildren();
        while (t.hasMoreElements()) {
            XMLObject testament = (XMLObject)t.nextElement();
            boolean found = false;
            for (int i = 0; i < testamentTags.length; ++i) {
                if (!testament.getTag().equals(testamentTags[i])) continue;
                found = true;
                break;
            }
            if (!found) continue;
            Enumeration e = testament.getChildren();
            while (e.hasMoreElements()) {
                XMLObject xmlBook = (XMLObject)e.nextElement();
                if (!xmlBook.getTag().equals(bookTag)) continue;
                Book book = new Book(xmlBook, this, primaryBookNameAttribute, secondaryBookNameAttribute);
                if (!book.hasVerses()) {
                    System.out.println("Error: Book (" + book.name + ") doesn't contain any verses.");
                    ++numBooksWithOutVerses;
                }
                books.put(book.name, book);
                bookNames.add(book.name);
            }
        }
        if (numBooksWithOutVerses > 0) {
            // empty if block
        }
        return books;
    }

    public static void parseUiProperties() throws IOException {
        File uiFile = new File(GoBibleCreator.getJarDirectory(), "GoBibleCore/ui.properties");
        boolean bRet = uiFile.exists();
        String sFileExists = "False";
        if (bRet) {
            sFileExists = "True";
        }
        System.out.println(uiFile.getAbsolutePath() + "  exists:" + sFileExists);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(uiFile), "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("UI-")) {
                int index = line.indexOf(58);
                uiProperties.put(line.substring(0, index), line.substring(index + 1));
                continue;
            }
            if (line.trim().equals("")) continue;
            System.out.println("Error parsing ui.properties file. Can't understand line:\n" + line);
        }
        reader.close();
    }

    public static Vector parseCollectionsFile(File collectionsFile, HashMap books) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(collectionsFile), "UTF-8"));
        Vector<Collection> collections = new Vector<Collection>();
        Collection collection = null;
        String line = null;
        int lineCount = 0;
        while ((line = reader.readLine()) != null) {
            ++lineCount;
            if (line.trim().equals("") || line.startsWith("//") || line.startsWith("rem") || line.startsWith("REM")) continue;
            if (line.startsWith("Wap-site:")) {
                wapSite = line.substring(9).trim();
                continue;
            }
            if (line.startsWith("MIDlet-Info-URL:")) {
                midlet_infoURL = line.substring("MIDlet-Info-URL:".length()).trim();
                continue;
            }
            if (line.startsWith("MIDlet-Vendor:")) {
                midlet_vendor = line.substring("MIDlet-Vendor:".length()).trim();
                continue;
            }
            if (line.startsWith("Source-Text:") || line.startsWith("Source-FileExtension:") || line.startsWith("Source-Format:") || line.startsWith("USFM-TitleTag:")) continue;
            if (line.startsWith("Phone-Icon-Filepath:")) {
                phoneIconFilepath = line.substring("Phone-Icon-Filepath:".length()).trim();
                continue;
            }
            if (line.startsWith("Codepage:")) {
                fileCodepage = line.substring("Codepage:".length()).trim();
                continue;
            }
            if (line.startsWith("Application-Name:")) {
                applicationName = line.substring("Application-Name:".length()).trim();
                continue;
            }
            if (line.startsWith("RedLettering:")) {
                if (line.toLowerCase().indexOf("false") <= 0 && line.toLowerCase().indexOf("no") <= 0) continue;
                useRedLettering = false;
                continue;
            }
            if (line.startsWith("Info:")) {
                infoString = line.substring(5).trim();
                continue;
            }
            if (line.startsWith("Custom-Font:")) {
                customFontString = line.substring(12).trim();
                continue;
            }
            if (line.startsWith("Language-Code:")) {
                int commaIndex = line.indexOf(44);
                if (commaIndex == -1) {
                    languageCode = line.substring(14).trim();
                    languageCodePosition = languageCodePositionType.suffix;
                    continue;
                }
                languageCode = line.substring(14, commaIndex);
                String langPosition = line.substring(commaIndex + 1).trim();
                if (langPosition.equalsIgnoreCase("prefix")) {
                    languageCodePosition = languageCodePositionType.prefix;
                    continue;
                }
                if (langPosition.equalsIgnoreCase("suffix")) {
                    languageCodePosition = languageCodePositionType.suffix;
                    continue;
                }
                languageCodePosition = languageCodePositionType.suffix;
                System.out.println("Error parsing collections file. Unsupported Language-Code position: " + langPosition + ", use 'prefix' or 'suffix'. (EX: Language-Code: en, prefix)");
                continue;
            }
            if (line.startsWith("MIDP:")) {
                String midpVersionString = line.substring(5).trim();
                if (midpVersionString.equals(midpVersion)) continue;
                System.out.println("Error parsing collections file. Unsupported MIDP version: " + midpVersionString + ", use " + midpVersion);
                continue;
            }
            if (line.startsWith("Align:")) {
                String alignString = line.substring(6).trim().toLowerCase();
                if (alignString.equals("left")) {
                    align = 0;
                    continue;
                }
                if (alignString.equals("right")) {
                    align = 1;
                    continue;
                }
                System.out.println("Error passing collections file. Did not understand align property: '" + alignString + "'. Must be either 'Left' or 'Right'.");
                continue;
            }
            if (line.startsWith("Book-Name-Map:")) {
                String bookShortName = line.substring(14);
                int commaIndex = bookShortName.indexOf(44);
                String bookLongName = bookShortName.substring(commaIndex + 1).trim();
                bookShortName = bookShortName.substring(0, commaIndex).trim();
                if (updateOnly) continue;
                Book book = (Book)books.get(bookShortName);
                if (book == null) {
                    System.out.println("Warning: can't find book name: " + bookShortName);
                    System.out.println("Check Book-Name-Map entries with source text file[s].");
                    continue;
                }
                book.name = bookLongName;
                continue;
            }
            if (line.startsWith("Collection:")) {
                String collectionName;
                String fileName = collectionName = line.substring(11).trim();
                int commaIndex = collectionName.indexOf(44);
                if (commaIndex != -1) {
                    fileName = collectionName.substring(0, commaIndex);
                    collectionName = collectionName.substring(commaIndex + 1);
                }
                collection = languageCodePosition == languageCodePositionType.suffix ? new Collection(fileName + " " + languageCode, collectionName + " " + languageCode) : new Collection(languageCode + " " + fileName, languageCode + " " + collectionName);
                collections.add(collection);
                continue;
            }
            if (line.startsWith("Book:")) {
                if (collection == null) {
                    System.out.println("'Book:' without collection on line " + reader.getLineNumber());
                }
                String bookName = line.substring(5);
                int startChapter = -1;
                int endChapter = -1;
                int commaIndex = bookName.indexOf(44);
                if (commaIndex >= 0) {
                    String startChapterString = bookName.substring(commaIndex + 1);
                    bookName = bookName.substring(0, commaIndex);
                    commaIndex = startChapterString.indexOf(44);
                    if (commaIndex >= 0) {
                        String endChapterString = startChapterString.substring(commaIndex + 1).trim();
                        startChapterString = startChapterString.substring(0, commaIndex).trim();
                        startChapter = Integer.parseInt(startChapterString);
                        endChapter = Integer.parseInt(endChapterString);
                    } else {
                        System.out.println("Start chapter specified without end chapter on line " + reader.getLineNumber());
                    }
                }
                bookName = bookName.trim();
                if (sourceFormatType == SourceFormatType.usfm) {
                    bookName = USFM_Utilities.CleanBookName(bookName);
                }
                if (startChapter == -1 && !updateOnly) {
                    Book xmlBook = (Book)books.get(bookName);
                    if (xmlBook == null) {
                        System.out.println("Couldn't find book: " + bookName);
                    }
                    startChapter = xmlBook.startChapter;
                    endChapter = xmlBook.chapters.size() + startChapter - 1;
                }
                Book book = new Book(bookName, startChapter, endChapter);
                collection.add(book);
                continue;
            }
            if (line.startsWith("UI-")) {
                int index = line.indexOf(58);
                uiProperties.put(line.substring(0, index), line.substring(index + 1));
                continue;
            }
            if (line.startsWith("Empty-Verse-Text:")) {
                EmptyVerseString = line.substring(15).trim();
                continue;
            }
            if (line.trim().equals("")) continue;
            System.out.println("Error parsing collections file. Can't understand line<" + lineCount + ">:\n" + line);
        }
        reader.close();
        return collections;
    }

    public static void writeCollections(File directory, Vector collections, HashMap books, JarFile goBibleJar) throws IOException {
        Enumeration e = collections.elements();
        while (e.hasMoreElements()) {
            Collection collection = (Collection)e.nextElement();
            System.out.println("Writing Collection " + collection.fileName + ": ");
            GoBibleCreator.writeCollection(directory, collection, books, goBibleJar);
        }
    }

    public static void writeCollection(File directory, Collection collection, HashMap books, JarFile goBibleJar) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        if (applicationName != null) {
            attributes.putValue("MIDlet-Name", collection.name + " " + applicationName);
            attributes.putValue("MIDlet-1", collection.name + " " + applicationName + ", Icon.png, GoBible");
        } else {
            attributes.putValue("MIDlet-Name", collection.name + NAME_APPENDAGE);
            attributes.putValue("MIDlet-1", collection.name + NAME_APPENDAGE + ", Icon.png, GoBible");
        }
        attributes.putValue("MIDlet-Icon", "Icon.png");
        if (midlet_vendor == null) {
            midlet_vendor = "Jolon Faichney";
        }
        attributes.putValue("MIDlet-Vendor", midlet_vendor);
        attributes.putValue("MIDlet-Version", versionString);
        attributes.putValue("MIDlet-Data-Size", "100");
        attributes.putValue("MicroEdition-Configuration", "CLDC-1.0");
        attributes.putValue("MicroEdition-Profile", midpVersion);
        if (infoString != null) {
            attributes.putValue("Go-Bible-Info", infoString);
        }
        attributes.putValue("Go-Bible-Align", ALIGN_TEXT[align]);
        String uiPropertiesString = "";
        Set uiMappings = uiProperties.entrySet();
        for (Map.Entry entry : uiMappings) {
            uiPropertiesString = uiPropertiesString + entry.getKey() + ":" + entry.getValue() + "\n";
        }
        File jarFile = new File(directory, collection.fileName + ".jar");
        if (updateOnly) {
            GoBibleCreator.updateCollectionJar(directory, jarFile, collection, goBibleJar, manifest, uiPropertiesString);
        } else {
            GoBibleCreator.writeCollectionJar(directory, jarFile, collection, books, goBibleJar, manifest, uiPropertiesString);
        }
        GoBibleCreator.createJadFile(directory, collection, jarFile.length(), collection.fileName + ".jar");
        if (wapSite != null) {
            File wapDirectory = new File(directory, "wap");
            if (!wapDirectory.exists()) {
                wapDirectory.mkdir();
            }
            GoBibleCreator.createJadFile(wapDirectory, collection, jarFile.length(), wapSite + "/" + directory.getName() + "/" + collection.fileName + ".jar");
        }
    }

    public static void updateCollectionJar(File directory, File jarFile, Collection collection, JarFile goBibleJar, Manifest manifest, String uiPropertiesString) throws IOException {
        if (jarFile.exists()) {
            File tmpFile = new File(directory, collection.fileName + ".jar" + ".tmp");
            jarFile.renameTo(tmpFile);
            jarFile = new File(directory, collection.fileName + ".jar");
            JarFile tmpJar = new JarFile(tmpFile);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarFile)), manifest);
            GoBibleCreator.copyInContentsOfJar(tmpJar, jarOutputStream, "Bible Data");
            GoBibleCreator.copyInContentsOfJar(goBibleJar, jarOutputStream, null);
            jarOutputStream.putNextEntry(new JarEntry(UI_PROPERTIES_FILE_NAME));
            jarOutputStream.write(uiPropertiesString.getBytes("UTF-8"));
            jarOutputStream.close();
            tmpFile.delete();
        } else {
            System.out.println("Error: existing JAR file does not exist: " + jarFile.getAbsolutePath());
            System.out.println("An existing JAR file must exist when the -u option is used.");
        }
    }

    public static void writeCollectionJar(File directory, File jarFile, Collection collection, HashMap books, JarFile goBibleJar, Manifest manifest, String uiPropertiesString) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarFile)), manifest);
        GoBibleCreator.copyInContentsOfJar(goBibleJar, jarOutputStream, null);
        jarOutputStream.putNextEntry(new JarEntry(UI_PROPERTIES_FILE_NAME));
        jarOutputStream.write(uiPropertiesString.getBytes("UTF-8"));
        GoBibleCreator.writeMultipleIndex(jarOutputStream, collection, books);
        GoBibleCreator.writeMultipleBooks(jarOutputStream, collection, books);
        jarOutputStream.close();
        System.out.println(collection.books.size() + " book(s) written.");
    }

    public static void copyInContentsOfJar(JarFile jar, JarOutputStream jarOutputStream, String name) throws IOException {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            int count;
            byte[] buffer;
            BufferedInputStream inputStream;
            JarEntry jarEntry = e.nextElement();
            String entryName = jarEntry.getName();
            String sFilepath = "";
            if (entryName.startsWith("META-INF") || entryName.equals(UI_PROPERTIES_FILE_NAME) || name != null && !entryName.startsWith(name)) continue;
            boolean bNewIcon = false;
            if (entryName.equals("Icon.png") && phoneIconFilepath != null) {
                File oFile = new File(baseSourceDirectory, phoneIconFilepath);
                if (oFile.exists()) {
                    bNewIcon = true;
                    sFilepath = oFile.getPath();
                } else {
                    System.out.println("Error: Icon file doesn't exist <" + phoneIconFilepath + ">.");
                }
            }
            if (!bNewIcon) {
                int length;
                jarOutputStream.putNextEntry(jarEntry);
                inputStream = new BufferedInputStream(jar.getInputStream(jarEntry));
                buffer = new byte[100000];
                while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                    jarOutputStream.write(buffer, 0, length);
                }
                ((InputStream)inputStream).close();
                continue;
            }
            buffer = new byte[100000];
            FileInputStream fi = new FileInputStream(sFilepath);
            inputStream = new BufferedInputStream(fi, 100000);
            ZipEntry entry = new ZipEntry("Icon.png");
            jarOutputStream.putNextEntry(entry);
            while ((count = ((InputStream)inputStream).read(buffer, 0, 100000)) != -1) {
                jarOutputStream.write(buffer, 0, count);
            }
            ((InputStream)inputStream).close();
        }
    }

    public static void createJadFile(File directory, Collection collection, long jarFileLength, String url) throws IOException {
        File jadFile = new File(directory, collection.fileName + ".jad");
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jadFile), "UTF-8")));
        if (applicationName != null) {
            writer.println("MIDlet-1: " + collection.name + " " + applicationName + ", Icon.png, GoBible");
            writer.println("MIDlet-Name: " + collection.name + " " + applicationName);
        } else {
            writer.println("MIDlet-1: " + collection.name + NAME_APPENDAGE + ", Icon.png, GoBible");
            writer.println("MIDlet-Name: " + collection.name + NAME_APPENDAGE);
        }
        writer.println("MIDlet-Icon: Icon.png");
        writer.println("MIDlet-Jar-Size: " + jarFileLength);
        writer.println("MIDlet-Jar-URL: " + url);
        if (midlet_infoURL == null) {
            midlet_infoURL = "http://wap.jolon.org";
        }
        writer.println("MIDlet-Info-URL: " + midlet_infoURL);
        if (midlet_vendor == null) {
            midlet_vendor = "Jolon Faichney";
        }
        writer.println("MIDlet-Vendor: " + midlet_vendor);
        writer.println("MIDlet-Version: " + versionString);
        writer.println("MIDlet-Data-Size: 100");
        writer.println("MicroEdition-Profile: " + midpVersion);
        if (infoString != null) {
            writer.println("Go-Bible-Info: " + infoString + " Ver. " + versionString);
        }
        writer.println("Go-Bible-Align: " + ALIGN_TEXT[align]);
        writer.close();
    }

    public static void writeMultipleIndex(JarOutputStream jarOutputStream, Collection collection, HashMap books) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
        output.write(collection.books.size());
        Enumeration e = collection.books.elements();
        while (e.hasMoreElements()) {
            Book collectionBook = (Book)e.nextElement();
            Book thmlBook = (Book)books.get(collectionBook.name);
            output.writeUTF(thmlBook.name);
            output.writeUTF(thmlBook.fileName);
            output.writeShort(collectionBook.startChapter);
            output.writeShort(collectionBook.endChapter - collectionBook.startChapter + 1);
            int fileNumber = 0;
            int fileLength = 0;
            for (int i = collectionBook.startChapter; i <= collectionBook.endChapter; ++i) {
                Chapter chapter = (Chapter)thmlBook.chapters.elementAt(i - thmlBook.startChapter);
                if (fileLength != 0 && fileLength + chapter.allVerses.length() - MAX_FILE_SIZE > MAX_FILE_SIZE - fileLength) {
                    fileLength = 0;
                }
                fileLength += chapter.allVerses.length();
                chapter.fileNumber = ++fileNumber;
                output.write(fileNumber);
                output.writeInt(chapter.allVerses.length());
                output.write(chapter.verses.size());
            }
        }
        output.close();
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        jarOutputStream.putNextEntry(new JarEntry("Bible Data/Index"));
        jarOutputStream.write(byteArray, 0, byteArray.length);
    }

    public static void writeMultipleBooks(JarOutputStream jarOutputStream, Collection collection, HashMap books) throws IOException {
        Enumeration e = collection.books.elements();
        while (e.hasMoreElements()) {
            Book collectionBook = (Book)e.nextElement();
            Book thmlBook = (Book)books.get(collectionBook.name);
            System.out.print(thmlBook.fileName + ", ");
            GoBibleCreator.writeMultipleBookIndex(jarOutputStream, collectionBook, thmlBook);
            DataOutputStream dataOutputStream = new DataOutputStream(jarOutputStream);
            int fileNumber = 0;
            StringBuffer buffer = new StringBuffer();
            for (int chapterNumber = collectionBook.startChapter; chapterNumber <= collectionBook.endChapter; ++chapterNumber) {
                Chapter chapter = (Chapter)thmlBook.chapters.elementAt(chapterNumber - thmlBook.startChapter);
                if (chapter.fileNumber != fileNumber) {
                    jarOutputStream.putNextEntry(new JarEntry("Bible Data/" + thmlBook.fileName + "/" + thmlBook.fileName + " " + fileNumber));
                    byte[] verseBytes = buffer.toString().getBytes("UTF-8");
                    dataOutputStream.writeInt(verseBytes.length);
                    dataOutputStream.write(verseBytes, 0, verseBytes.length);
                    fileNumber = chapter.fileNumber;
                    buffer = new StringBuffer();
                }
                buffer.append(chapter.allVerses.toString());
            }
            jarOutputStream.putNextEntry(new JarEntry("Bible Data/" + thmlBook.fileName + "/" + thmlBook.fileName + " " + fileNumber));
            byte[] verseBytes = buffer.toString().getBytes("UTF-8");
            dataOutputStream.writeInt(verseBytes.length);
            dataOutputStream.write(verseBytes, 0, verseBytes.length);
        }
    }

    public static void writeMultipleBookIndex(JarOutputStream jarOutputStream, Book collectionBook, Book xmlBook) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
        for (int chapterNumber = collectionBook.startChapter; chapterNumber <= collectionBook.endChapter; ++chapterNumber) {
            Chapter chapter = (Chapter)xmlBook.chapters.elementAt(chapterNumber - xmlBook.startChapter);
            Enumeration e = chapter.verses.elements();
            while (e.hasMoreElements()) {
                String verse = (String)e.nextElement();
                output.writeShort(verse.length());
            }
        }
        output.close();
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        jarOutputStream.putNextEntry(new JarEntry("Bible Data/" + xmlBook.fileName + "/Index"));
        jarOutputStream.write(byteArray, 0, byteArray.length);
    }

    public static void generateCustomFont(String customFontString, File collectionsFile, HashMap books) throws IOException {
        System.out.println("Generating fonts...");
        File glyphDirectory = new File(collectionsFile.getParent(), "glyphs");
        if (!glyphDirectory.exists()) {
            glyphDirectory.mkdir();
        }
        Font font = new Font(customFontString, 0, 14);
        BufferedImage testFontImage = new BufferedImage(1, 1, 2);
        Graphics2D testGraphics = (Graphics2D)testFontImage.getGraphics();
        testGraphics.setFont(font);
        FontMetrics fontMetrics = testGraphics.getFontMetrics();
        int ascent = fontMetrics.getAscent();
        FontRenderContext testFontRenderContext = testGraphics.getFontRenderContext();
        HashMap<Integer, BufferedImage> glyphs = new HashMap<Integer, BufferedImage>();
        for (Object bookObject : books.values()) {
            Book book = (Book)bookObject;
            for (Object chapterObject : book.chapters) {
                Chapter chapter = (Chapter)chapterObject;
                char[] charArray = chapter.allVerses.toString().toCharArray();
                int startIndex = 0;
                int c = 0;
                for (int i = 0; i < charArray.length; ++i) {
                    c |= charArray[i];
                    if (i < charArray.length - 1 && charArray[i + 1] >= '\u0bbe' && charArray[i + 1] <= '\u0bcd') {
                        startIndex = i;
                        c <<= 16;
                        continue;
                    }
                    if (!glyphs.containsKey(c)) {
                        Rectangle2D stringBounds = font.getStringBounds(charArray, startIndex, i + 1, testFontRenderContext);
                        String hexString = Integer.toHexString(c);
                        System.out.println(hexString + ": " + (char)c + ", height: " + fontMetrics.getHeight());
                        BufferedImage fontImage = new BufferedImage((int)stringBounds.getWidth(), fontMetrics.getHeight(), 2);
                        Graphics2D graphics = (Graphics2D)fontImage.getGraphics();
                        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics.setColor(Color.BLACK);
                        graphics.setFont(font);
                        graphics.drawString(new String(charArray, startIndex, i - startIndex + 1), 0, ascent);
                        glyphs.put(c, fontImage);
                    }
                    startIndex = i + 1;
                    c = 0;
                }
            }
        }
        HashMap<Integer, Integer> glyphIndexes = new HashMap<Integer, Integer>();
        int index = 0;
        Iterator i$ = glyphs.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            glyphIndexes.put(key, index);
            ImageIO.write((RenderedImage)glyphs.get(key), "PNG", new File(glyphDirectory, index + ".png"));
            ++index;
        }
        System.out.println("Fonts generated.");
    }

    public abstract HashMap parse(XMLObject var1);

    public abstract boolean isChapter(XMLObject var1);

    public abstract int getChapterNumber(XMLObject var1);

    public abstract void parseChapter(XMLObject var1, Chapter var2);

    public String trim(String string) {
        String result = string;
        if (string.length() > 0) {
            int charIndex;
            char[] charArray = string.toCharArray();
            char currentChar = charArray[charIndex];
            for (charIndex = 0; charIndex < charArray.length && charArray[charIndex] > '\u0001' && charArray[charIndex] <= ' '; ++charIndex) {
            }
            int startIndex = charIndex;
            if (startIndex < charArray.length) {
                for (charIndex = charArray.length - 1; charIndex >= 0 && charArray[charIndex] > '\u0001' && charArray[charIndex] <= ' '; --charIndex) {
                }
                result = string.substring(startIndex, charIndex + 1);
            } else {
                result = "";
            }
        }
        return result;
    }

    public String convertAmpersands(String text) {
        String result = "";
        int semiColonIndex = -1;
        int ampersandIndex = -1;
        do {
            if ((ampersandIndex = text.indexOf(38, semiColonIndex + 1)) == -1) continue;
            result = result + text.substring(semiColonIndex + 1, ampersandIndex);
            semiColonIndex = text.indexOf(59, ampersandIndex + 1);
            String type = text.substring(ampersandIndex + 1, semiColonIndex);
            if (!type.equals("quot")) continue;
            result = result + '\"';
        } while (ampersandIndex != -1);
        result = result + text.substring(semiColonIndex + 1);
        return result;
    }

    public static String extractCDATA(XMLObject xml) {
        String result = "";
        Enumeration e = xml.getChildren();
        while (e.hasMoreElements()) {
            XMLObject child = (XMLObject)e.nextElement();
            if (child instanceof CDATA) {
                result = result + child.getTag();
                continue;
            }
            if (child.getTag().equals("sup") || child.getTag().equals("reference") || child.getTag().equals("title")) continue;
            result = result + GoBibleCreator.extractCDATA(child);
        }
        return result;
    }

    static {
        uiProperties = new HashMap();
        bookNames = new Vector();
        baseSourceDirectory = null;
        usfmSourceFileExtension = null;
        phoneIconFilepath = null;
        fileCodepage = null;
        applicationName = null;
        useRedLettering = true;
        sTitleTag = "\\h";
        EmptyVerseString = null;
    }

    public static enum SourceFormatType {
        osis,
        thml,
        usfm,
        unknown;

    }

    public static enum languageCodePositionType {
        prefix,
        suffix;

    }
}

