/*
 * Decompiled with CFR 0.152.
 */
package jolon.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import jolon.xml.CDATA;
import jolon.xml.XMLAttribute;
import jolon.xml.XMLCompatible;
import jolon.xml.XMLObject;

public class XMLParser {
    LineNumberReader inputStream;
    Stack tagStack;
    char currentChar;
    boolean EOF = false;

    public static XMLObject parse(String string) throws IOException {
        XMLParser xMLParser = new XMLParser();
        return xMLParser.parse(new File(string));
    }

    public static XMLObject parseFile(File file) throws IOException {
        XMLParser xMLParser = new XMLParser();
        return xMLParser.parse(file);
    }

    public XMLParser(Reader reader) {
        this.inputStream = new LineNumberReader(reader);
    }

    public XMLParser() {
    }

    public int getLineNumber() {
        int n = -1;
        if (this.inputStream != null) {
            n = this.inputStream.getLineNumber();
        }
        return n;
    }

    public XMLObject parse(File file) throws IOException {
        return this.parse(file, null);
    }

    public XMLObject parse(File file, Hashtable hashtable) throws IOException {
        String string = file.getName();
        XMLObject xMLObject = null;
        if (string.endsWith(".wbxml")) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            xMLObject = this.parseWBXML(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        } else {
            this.inputStream = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            xMLObject = this.parse(hashtable);
        }
        return xMLObject;
    }

    public XMLObject parse() {
        return this.parse((Hashtable)null);
    }

    public XMLObject parse(Hashtable hashtable) {
        this.tagStack = new Stack();
        Object object = new XMLObject("root");
        this.currentChar = (char)32;
        this.EOF = false;
        while (!this.EOF) {
            Object object2;
            String string = this.readTag((XMLCompatible)object);
            if (string.length() <= 0 || this.isXMLTag(string)) continue;
            if (this.isEndTag(string)) {
                object2 = object.getTag();
                if (string.regionMatches(1, (String)object2, 0, ((String)object2).length())) {
                    object = (XMLCompatible)this.tagStack.pop();
                    continue;
                }
                System.out.println("Error: Line: " + (this.inputStream.getLineNumber() + 1) + ": End tag <" + string + "> does not have a matching start tag (found <" + (String)object2 + "> instead), ignoring.");
                continue;
            }
            if (!string.endsWith("/")) {
                this.tagStack.push(object);
            }
            object2 = this.createXMLObject(string);
            if (hashtable != null && hashtable.containsKey(object2.getTag())) {
                try {
                    XMLCompatible xMLCompatible = (XMLCompatible)((Class)hashtable.get(object2.getTag())).newInstance();
                    xMLCompatible.fromXML((XMLObject)object2);
                    object2 = xMLCompatible;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
            }
            object2 = object.addXMLChild((XMLCompatible)object2);
            if (string.endsWith("/")) continue;
            object = object2;
        }
        return object;
    }

    public String readTag(XMLCompatible xMLCompatible) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            boolean bl;
            char c;
            int n = 0;
            String string = "";
            do {
                n = this.inputStream.read();
                c = (char)n;
                if (n == -1 || c == '<') continue;
                string = string + c;
            } while (n != -1 && c != '<');
            if (!string.trim().equals("")) {
                xMLCompatible.addXMLChild(new CDATA(string));
            }
            boolean bl2 = bl = c == '\"';
            while (n != -1 && (c != '>' || bl)) {
                n = this.inputStream.read();
                c = (char)n;
                if (c == '\"') {
                    boolean bl3 = bl = !bl;
                }
                if (c == '>' && !bl || n == -1) continue;
                stringBuffer.append(c);
            }
            if (n == -1) {
                this.EOF = true;
            }
        }
        catch (IOException iOException) {
            System.out.println("An IO error has occurred in XMLParser.readTag().");
        }
        return stringBuffer.toString();
    }

    protected XMLObject createXMLObject(String string) {
        int n = this.findEndOfTagName(string);
        String string2 = string.substring(0, n);
        XMLObject xMLObject = new XMLObject(string2);
        this.getAttributes(xMLObject, string, n);
        return xMLObject;
    }

    protected int findEndOfTagName(String string) {
        int n;
        int n2 = n = string.length();
        for (int i = 0; i < n && n2 == n; ++i) {
            char c = string.charAt(i);
            if (!this.isWhiteSpace(c) && c != '>' && c != '/') continue;
            n2 = i;
        }
        return n2;
    }

    public boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    protected void getAttributes(XMLObject xMLObject, String string, int n) {
        do {
            XMLAttribute xMLAttribute;
            if ((n = this.getAttribute(string, n + 1, xMLAttribute = new XMLAttribute())) == -1) continue;
            xMLObject.add(xMLAttribute);
        } while (n != -1);
    }

    protected int getAttribute(String string, int n, XMLAttribute xMLAttribute) {
        int n2 = n;
        int n3 = 47;
        int n4 = string.length();
        boolean bl = true;
        if (n >= n4) {
            return -1;
        }
        n3 = string.charAt(n);
        if (n < n4 && n3 != 47 && n3 != 62) {
            int n5 = string.indexOf(61, n);
            if (n5 == -1) {
                return -1;
            }
            xMLAttribute.setName(string.substring(n, n5).trim());
            int n6 = string.indexOf(34, n5);
            if (n6 == -1 || n6 + 1 >= n4) {
                return -1;
            }
            int n7 = string.indexOf(34, n6 + 1);
            if (n7 == -1) {
                return -1;
            }
            xMLAttribute.setData(string.substring(n6 + 1, n7));
            n = n7;
        } else {
            n = -1;
        }
        return n;
    }

    public boolean isXMLTag(String string) {
        return string.startsWith("?") && string.endsWith("?");
    }

    public boolean isEndTag(String string) {
        return string.charAt(0) == '/';
    }

    public XMLObject parseWBXML(InputStream inputStream) throws IOException {
        XMLObject xMLObject = new XMLObject("root");
        Hashtable hashtable = this.readStart(inputStream);
        this.parseWBXML(xMLObject, inputStream, hashtable);
        return xMLObject;
    }

    public boolean parseWBXML(XMLObject xMLObject, InputStream inputStream, Hashtable hashtable) throws IOException {
        int n = inputStream.read();
        if (n != 1) {
            int n2;
            String string = this.readIndexedString(inputStream, hashtable);
            XMLObject xMLObject2 = new XMLObject(string);
            if ((n & 0x80) != 0) {
                n2 = inputStream.read();
                do {
                    String string2 = null;
                    if (n2 != 4) {
                        throw new IOException("attributeName is null");
                    }
                    string2 = this.readIndexedString(inputStream, hashtable);
                    n2 = inputStream.read();
                    String string3 = null;
                    if (n2 == 83) {
                        string3 = this.readIndexedString(inputStream, hashtable);
                        xMLObject2.addAttribute(string2, string3);
                        continue;
                    }
                    if (n2 != 81) continue;
                    int n3 = this.readMultibyteInteger(inputStream);
                    xMLObject2.addAttribute(string2, Float.intBitsToFloat(n3));
                } while ((n2 = inputStream.read()) != 1);
            }
            if ((n & 0x40) != 0) {
                n2 = 0;
                while (this.parseWBXML(xMLObject2, inputStream, hashtable)) {
                }
            }
            xMLObject.add(xMLObject2);
            return true;
        }
        return false;
    }

    public String readIndexedString(InputStream inputStream, Hashtable hashtable) throws IOException {
        int n = this.readMultibyteInteger(inputStream);
        return (String)hashtable.get(new Integer(n));
    }

    public Hashtable readStart(InputStream inputStream) throws IOException {
        System.out.println("readStart");
        this.readVersion(inputStream);
        this.readPublicID(inputStream);
        this.readCharSet(inputStream);
        System.out.println("readStringTable");
        return this.readStringTable(inputStream);
    }

    public void readVersion(InputStream inputStream) throws IOException {
        inputStream.read();
    }

    public void readPublicID(InputStream inputStream) throws IOException {
        inputStream.read();
    }

    public void readCharSet(InputStream inputStream) throws IOException {
        inputStream.read();
    }

    public Hashtable readStringTable(InputStream inputStream) throws IOException {
        String string;
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n = this.readMultibyteInteger(inputStream);
        System.out.println("length = " + n);
        for (int i = 0; i < n; i += string.length() + 1) {
            string = this.readNullTerminatedString(inputStream);
            hashtable.put(new Integer(i), string);
        }
        return hashtable;
    }

    public int readMultibyteInteger(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("End of file");
        }
        int n2 = n & 0x7F;
        while ((n & 0x80) != 0) {
            n = inputStream.read();
            if (n == -1) {
                throw new IOException("End of file");
            }
            n2 <<= 7;
            n2 |= n & 0x7F;
        }
        return n2;
    }

    public String readNullTerminatedString(InputStream inputStream) throws IOException {
        String string = "";
        int n = inputStream.read();
        while (n != 0) {
            string = string + (char)n;
            n = inputStream.read();
        }
        return string;
    }
}

