-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local trajectories = frames.transform ()
local spins = frames.transform {}
local velocities = frames.transform {}
local crosshairs

local fader = frames.timer {
   period = 0,

   transform = function (tick, delta, elapsed)
		  -- Fade out the trajectory lines.

		  for i = 1, #balls do
		     if trajectories[i] then
			trajectories[i].opacity = 0.5 * (1 - elapsed)
		     end
		  end
		     
		  if elapsed > 1 then
		     graph.tracer = nil
		  end
	       end,

   unlink = function ()
	       for i = 1, #balls do
		  trajectories[i] = nil
	       end
	    end
}

local plotter = frames.custom {
   link = function()
	     for i = 1, #balls do
		spins[i] = shapes.line {
		   color = {.7, 0.6, 0.4},
		   opacity = 0.85,
		   width = 2
		}
		
		velocities[i] = shapes.line {
		   color = {0.4, 0.6, 0.7},
		   opacity = 0.85,
		   width = 2
		}
	     end
	  end,

   transform = function ()
		  -- Plot ball spin and velocity vectors.

		  for i, ball in ipairs (balls) do
		     local c = ball.position
		     local v = ball.velocity
		     local w = ball.spin

		     spins[i][1] = c
		     spins[i][2] = {c[1] + 0.01 * w[1],
				    c[2] + 0.01 * w[2],
				    c[3] + 0.01 * w[3]}

		     velocities[i][1] = c
		     velocities[i][2] = {c[1] + 0.3 * v[1],
					 c[2] + 0.3 * v[2],
					 c[3] + 0.3 * v[3]}
		  end
	       end,
}

local tracer = frames.custom {
   link = function ()
	     -- Reset the trajectories

	     for i, ball in ipairs (balls) do
		trajectories[i] = shapes.line {
		   color = ball.surface.diffuse,
		   opacity = 0.5,
		   width = 2
		}
	     end
	  end,

   traverse = function ()
		 -- Add another point to the trajectory.

		 if waiting then
		    for i, ball in ipairs (balls) do
		       trajectories[i].vertex = ball.position
		    end
		 end
	      end,
}

-- Add the shooting aids to the scene.

-- Trajectories.

if billiards.drawtrajectories then
   graph.observer.trajectories = trajectories

   billiards.waiting.starttracing = function ()
      graph.tracer = tracer
   end

   billiards.finished.stoptracing = function ()
      graph.tracer = fader
   end

   billiards.looking.stoptracing = function ()
      graph.tracer = fader
   end
else
   graph.observer.trajectories = nil

   billiards.waiting.starttracing = nil
   billiards.finished.stoptracing = nil
   billiards.looking.stoptracing = nil
end

-- Vectors.

if billiards.drawvectors then
   graph.plotter = plotter

   graph.observer.spins = spins
   graph.observer.velocities = velocities
else
   graph.plotter = nil

   graph.observer.spins = nil
   graph.observer.velocities = nil
end

-- Crosshairs.

if billiards.drawcenterline or billiards.drawsidelines then
   crosshairs = frames.transform {
      transform = function ()
         crosshairs.position = cueball.position
         crosshairs.orientation = transforms.relue (90, 0, 90 + cue.heading)
      end
   }

   if billiards.drawcenterline then
      crosshairs.centerline = shapes.line {
	 opacity = 0.7,

	 {0, 0, 0},
	 {0, 0, -3}
      }
   end

   if billiards.drawsidelines then
      crosshairs.sidelines = shapes.dashed {
	 factor = 2,
      
	 left = shapes.line {
	    opacity = 0.7,

	    {billiards.ballradius, 0, 0},
	    {billiards.ballradius, 0, -2}
	 },

	 right = shapes.line {
	    opacity = 0.7,

	    {-billiards.ballradius, 0, 0},
	    {-billiards.ballradius, 0, -2}
	 }
      }
   end
   
   billiards.aiming.showcrosshairs = function ()
      graph.observer.crosshairs = crosshairs
   end
   
   billiards.waiting.hidecrosshairs = function ()
      graph.observer.crosshairs = nil
   end
   
   billiards.looking.hidecrosshairs = function ()
      graph.observer.crosshairs = nil
   end
else
   billiards.aiming.showcrosshairs = nil
   billiards.waiting.hidecrosshairs = nil
   billiards.looking.hidecrosshairs = nil
end
