-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local w = billiards.tablewidth
local h = billiards.tableheight
local w_0 = billiards.anchorwidth
local h_0 = billiards.anchorheight
local d = billiards.balkspacing
local r = billiards.ballradius + 1e-4

graph.observer.lines = shapes.lines {
   color = {0.22, 0.16, 0.07},
   opacity = 0.6,
   width = 1.5,

   -- Balk lines.

   {-0.5 * w, 0.5 * h - d, 0.001},
   {0.5 * w, 0.5 * h - d, 0.001},

   {-0.5 * w, -0.5 * h + d, 0.001},
   {0.5 * w, -0.5 * h + d, 0.001},

   {-0.5 * w + d, 0.5 * h, 0.001},
   {-0.5 * w + d, -0.5 * h, 0.001},
   
   {0.5 * w - d, 0.5 * h, 0.001},
   {0.5 * w - d, -0.5 * h, 0.001},

   -- Anchors.

   {-0.5 * w, 0.5 * (h - w_0) - d, 0.001},
   {-0.5 * w + h_0, 0.5 * (h - w_0) - d, 0.001},

   {-0.5 * w + h_0, 0.5 * (h - w_0) - d, 0.001},
   {-0.5 * w + h_0, 0.5 * (h + w_0) - d, 0.001},

   {-0.5 * w + h_0, 0.5 * (h + w_0) - d, 0.001},
   {-0.5 * w, 0.5 * (h + w_0) - d, 0.001},


   {-0.5 * w, -0.5 * (h - w_0) + d, 0.001},
   {-0.5 * w + h_0, -0.5 * (h - w_0) + d, 0.001},

   {-0.5 * w + h_0, -0.5 * (h - w_0) + d, 0.001},
   {-0.5 * w + h_0, -0.5 * (h + w_0) + d, 0.001},

   {-0.5 * w + h_0, -0.5 * (h + w_0) + d, 0.001},
   {-0.5 * w, -0.5 * (h + w_0) + d, 0.001},


   {0.5 * w, 0.5 * (h - w_0) - d, 0.001},
   {0.5 * w - h_0, 0.5 * (h - w_0) - d, 0.001},

   {0.5 * w - h_0, 0.5 * (h - w_0) - d, 0.001},
   {0.5 * w - h_0, 0.5 * (h + w_0) - d, 0.001},

   {0.5 * w - h_0, 0.5 * (h + w_0) - d, 0.001},
   {0.5 * w, 0.5 * (h + w_0) - d, 0.001},


   {0.5 * w, -0.5 * (h - w_0) + d, 0.001},
   {0.5 * w - h_0, -0.5 * (h - w_0) + d, 0.001},

   {0.5 * w - h_0, -0.5 * (h - w_0) + d, 0.001},
   {0.5 * w - h_0, -0.5 * (h + w_0) + d, 0.001},

   {0.5 * w - h_0, -0.5 * (h + w_0) + d, 0.001},
   {0.5 * w, -0.5 * (h + w_0) + d, 0.001},


   {-0.5 * (w + w_0) + d, -0.5 * h - h_0, 0.001},
   {-0.5 * (w + w_0) + d, -0.5 * h + h_0, 0.001},

   {-0.5 * (w + w_0) + d, -0.5 * h + h_0, 0.001},
   {-0.5 * (w - w_0) + d, -0.5 * h + h_0, 0.001},

   {-0.5 * (w - w_0) + d, -0.5 * h + h_0, 0.001},
   {-0.5 * (w - w_0) + d, -0.5 * h - h_0, 0.001},


   {0.5 * (w + w_0) - d, -0.5 * h - h_0, 0.001},
   {0.5 * (w + w_0) - d, -0.5 * h + h_0, 0.001},

   {0.5 * (w + w_0) - d, -0.5 * h + h_0, 0.001},
   {0.5 * (w - w_0) - d, -0.5 * h + h_0, 0.001},

   {0.5 * (w - w_0) - d, -0.5 * h + h_0, 0.001},
   {0.5 * (w - w_0) - d, -0.5 * h - h_0, 0.001},


   {-0.5 * (w + w_0) + d, 0.5 * h + h_0, 0.001},
   {-0.5 * (w + w_0) + d, 0.5 * h - h_0, 0.001},

   {-0.5 * (w + w_0) + d, 0.5 * h - h_0, 0.001},
   {-0.5 * (w - w_0) + d, 0.5 * h - h_0, 0.001},

   {-0.5 * (w - w_0) + d, 0.5 * h - h_0, 0.001},
   {-0.5 * (w - w_0) + d, 0.5 * h + h_0, 0.001},


   {0.5 * (w + w_0) - d, 0.5 * h + h_0, 0.001},
   {0.5 * (w + w_0) - d, 0.5 * h - h_0, 0.001},

   {0.5 * (w + w_0) - d, 0.5 * h - h_0, 0.001},
   {0.5 * (w - w_0) - d, 0.5 * h - h_0, 0.001},

   {0.5 * (w - w_0) - d, 0.5 * h - h_0, 0.001},
   {0.5 * (w - w_0) - d, 0.5 * h + h_0, 0.001},
}

graph.observer.gear.spaces = bodies.environment {
   -- West balk space.

   bodies.box {
      position = {-0.5 * (w - d - h_0), 0, 0.5 + r},
      size = {d - h_0 - 2 * r, h - 2 * d - 2 * r, 1},
      classification = 1
   },

   bodies.box {
      position = {-0.5 * (w - h_0 - r), 0, 0.5 + r},
      size = {h_0 + r, d - w_0 - 2 * r, 1},
      classification = 1
   },

   -- Southwest balk space.
   
   bodies.box {
      position = {-0.5 * (w - h_0 - d),
	       -0.5 * (h - h_0 - d),
	    0.5 + r},

      size = {d - h_0 - 2 * r, d - h_0 - 2 * r, 1},
      classification = 2
   },
   
   bodies.box {
      position = {-0.5 * (w - h_0 - r),
	       -0.5 * (h - d + 0.5 * w_0),
	    0.5 + r},

      size = {h_0 + r, d - 0.5 * w_0 - 2 * r, 1},
      classification = 2
   },
   
   bodies.box {

      position = {-0.5 * (w - d + 0.5 * w_0),
	       -0.5 * (h - h_0 - r),
	    0.5 + r},

      size = {d - 0.5 * w_0 - 2 * r, h_0 + r, 1},
      classification = 2
   },

   -- South balk space.

   bodies.box {
      position = {0, -0.5 * (h - d - h_0), 0.5 + r},
      size = {w - 2 * (d + r), d - 2 * r - h_0, 1},
      classification = 3
   },

   bodies.box {
      position = {0, -0.5 * (h - h_0 - r), 0.5 + r},
      size = {w - w_0 - 2 * (d + r), h_0 + r, 1},
      classification = 3
   },

   -- Southeast balk space.
   
   bodies.box {
      position = {0.5 * (w - h_0 - d),
	          -0.5 * (h - h_0 - d),
	          0.5 + r},

      size = {d - h_0 - 2 * r, d - h_0 - 2 * r, 1},
      classification = 4
   },
   
   bodies.box {
      position = {0.5 * (w - h_0 - r),
	          -0.5 * (h - d + 0.5 * w_0),
	          0.5 + r},

      size = {h_0 + r, d - 0.5 * w_0 - 2 * r, 1},
      classification = 4
   },
   
   bodies.box {

      position = {0.5 * (w - d + 0.5 * w_0),
	          -0.5 * (h - h_0 - r),
	          0.5 + r},

      size = {d - 0.5 * w_0 - 2 * r, h_0 + r, 1},
      classification = 4
   },

   -- East balk space.

   bodies.box {
      position = {0.5 * (w - d - h_0), 0, 0.5 + r},
      size = {d - h_0 - 2 * r, h - 2 * d - 2 * r, 1},
      classification = 5
   },

   bodies.box {
      position = {0.5 * (w - h_0 - r), 0, 0.5 + r},
      size = {h_0 + r, d - w_0 - 2 * r, 1},
      classification = 5
   },

   -- Northeast balk space.
   
   bodies.box {
      position = {0.5 * (w - h_0 - d),
		  0.5 * (h - h_0 - d),
		  0.5 + r},

      size = {d - h_0 - 2 * r, d - h_0 - 2 * r, 1},
      classification = 6
   },
   
   bodies.box {
      position = {0.5 * (w - h_0 - r),
		  0.5 * (h - d + 0.5 * w_0),
		  0.5 + r},

      size = {h_0 + r, d - 0.5 * w_0 - 2 * r, 1},
      classification = 6
   },
   
   bodies.box {

      position = {0.5 * (w - d + 0.5 * w_0),
		  0.5 * (h - h_0 - r),
		  0.5 + r},

      size = {d - 0.5 * w_0 - 2 * r, h_0 + r, 1},
      classification = 6
   },

   -- North balk space.

   bodies.box {
      position = {0, 0.5 * (h - d - h_0), 0.5 + r},
      size = {w - 2 * (d + r), d - 2 * r - h_0, 1},
      classification = 7
   },

   bodies.box {
      position = {0, 0.5 * (h - h_0 - r), 0.5 + r},
      size = {w - w_0 - 2 * (d + r), h_0 + r, 1},
      classification = 7
   },

   -- Northwest balk space.
   
   bodies.box {
      position = {-0.5 * (w - h_0 - d),
		  0.5 * (h - h_0 - d),
		  0.5 + r},

      size = {d - h_0 - 2 * r, d - h_0 - 2 * r, 1},
      classification = 8
   },
   
   bodies.box {
      position = {-0.5 * (w - h_0 - r),
		  0.5 * (h - d + 0.5 * w_0),
		  0.5 + r},

      size = {h_0 + r, d - 0.5 * w_0 - 2 * r, 1},
      classification = 8
   },
   
   bodies.box {

      position = {-0.5 * (w - d + 0.5 * w_0),
		  0.5 * (h - h_0 - r),
		  0.5 + r},

      size = {d - 0.5 * w_0 - 2 * r, h_0 + r, 1},
      classification = 6
   },

   -- Center balk space.
   
   bodies.box {
      position = {0, 0, 0.5 + r},
      size = {w- 2 * (d + r), h- 2 * (d + r), 1},
      classification = 9
   },

   -- West anchors.

   bodies.box {
      position = {-0.5 * (w - h_0), 0.5 * h - d, 0.5 + r},
      size = {h_0 - 2 * r, w_0 - 2 * r, 1},
      classification = 10
   },

   bodies.box {
      position = {-0.5 * (w - h_0), -0.5 * h + d, 0.5 + r},
      size = {h_0 - 2 * r, w_0 - 2 * r, 1},
      classification = 11
   },

   -- South anchors.

   bodies.box {
      position = {-0.5 * w + d, -0.5 * (h - h_0), 0.5 + r},
      size = {w_0 - 2 * r, h_0 - 2 * r, 1},
      classification = 12
   },

   bodies.box {
      position = {0.5 * w - d, -0.5 * (h - h_0), 0.5 + r},
      size = {w_0 - 2 * r, h_0 - 2 * r, 1},
      classification = 13
   },

   -- East anchors.

   bodies.box {
      position = {0.5 * (w - h_0), 0.5 * h - d, 0.5 + r},
      size = {h_0 - 2 * r, w_0 - 2 * r, 1},
      classification = 14
   },

   bodies.box {
      position = {0.5 * (w - h_0), -0.5 * h + d, 0.5 + r},
      size = {h_0 - 2 * r, w_0 - 2 * r, 1},
      classification = 15
   },

   -- North anchors.

   bodies.box {
      position = {-0.5 * w + d, 0.5 * (h - h_0), 0.5 + r},
      size = {w_0 - 2 * r, h_0 - 2 * r, 1},
      classification = 16
   },

   bodies.box {
      position = {0.5 * w - d, 0.5 * (h - h_0), 0.5 + r},
      size = {w_0 - 2 * r, h_0 - 2 * r, 1},
      classification = 17
   }
}
