-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


graphics.canvas = {0.1, 0.1, 0.11}

graph.observer.lamp = shading.light {
   position = {0, 0, 2.5},
   orientation = transforms.euler (180, 0, 0),

   intensity = {1, 1, 1}
}

graph.observer.bouncedlight = shading.ambient {
   intensity = {0.19, 0.15, 0.11}
}

graph.observer.fog = shading.fog {
   linear = 0.2,
   color = graphics.canvas
}

graph.observer.floor = shading.fixed {
   position = {0, 0, -0.866},

   diffuse = imagery.parquet.diffuse,
   parameter = 64,

   geometry.floor {}
}

graph.observer.table = shading.fixed {
   diffuse = imagery.table.diffuse,
   specular = {0.7, 0.7, 0.7},
   parameter = 32,

   geometry.table()
}

graph.observer.diamonds = shading.fixed {
   position = {0, 0, 1e-4},
   diffuse = {0.97, 0.87, 0.72},
   specular = {0.45, 0.435 , 0.425},
   parameter = 16,

   geometry.diamonds()
}

graph.observer.cloth = shading.fixed {
   diffuse = imagery.cloth,
   
   geometry.cloth(),
}

graph.observer.shadow = shading.fixed {
   diffuse = {0, 0, 0},
   specular = {0, 0, 0},

   shading.shadow {
      position = {0, 0, -0.865},
	 
      color = {0, 0, 0},
      
      geometry.table(),
      geometry.cloth()
   }
}

graph.observer.gear.cue.surface = shading.fixed {
   diffuse = imagery.cue,
   specular = {0.7, 0.7, 0.7},
   parameter = 64,
   
   geometry = geometry.cue()
}

graph.observer.gear.whiteball.surface = shading.fixed {
   diffuse = {0.97, 0.97, 0.82},
   specular = {0.5, 0.5, 0.5},
   parameter = 32,

   geometry = geometry.sphere()
}

graph.observer.gear.whiteball.shadow = frames.gimbal {
   shading.fixed {
      diffuse = {0, 0, 0},
      specular = {0, 0, 0},

      shading.shadow {
	 position = {0, 0, -billiards.ballradius + 0.001},
      
	 color = {0, 0, 0},
	 geometry = geometry.sphere()
      }
   }
}
	 
graph.observer.gear.yellowball.surface = shading.fixed {
   diffuse = {0.92, 0.66, 0.18},
   specular = {0.7, 0.7, 0.7},
   parameter = 32,
	    
   geometry = geometry.sphere()
}

graph.observer.gear.yellowball.shadow = frames.gimbal {
   shading.fixed {
      diffuse = {0, 0, 0},
      specular = {0, 0, 0},

      shading.shadow {
	 position = {0, 0, -billiards.ballradius + 0.001},
      
	 color = {0, 0, 0},
	 geometry = geometry.sphere()
      }
   }
}
	 
graph.observer.gear.redball.surface = shading.fixed {
   diffuse = {0.35, 0.1, 0.09},
   specular = {0.7, 0.7, 0.7},
   parameter = 32,

   geometry = geometry.sphere()
}

graph.observer.gear.redball.shadow = frames.gimbal {
   shading.fixed {
      diffuse = {0, 0, 0},
      specular = {0, 0, 0},

      shading.shadow {
	 position = {0, 0, -billiards.ballradius + 0.001},
      
	 color = {0, 0, 0},
	 geometry = geometry.sphere()
      }
   }
}
