-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local w = billiards.tablewidth
local h = billiards.tableheight
local r = billiards.ballradius + 1e-4
local d = billiards.crotchspacing
local l = math.sqrt(2) * d
local L = 0.5 * math.sqrt(2) * (w + h - 2 * d)

graph.observer.lines = shapes.lines {
   color = {0.22, 0.16, 0.07},
   opacity = 0.6,
   width = 1.5,

   {0.5 * w - d, 0.5 * h, 0.001},
   {0.5 * w, 0.5 * h - d, 0.001},   

   {-0.5 * w + d, 0.5 * h, 0.001},
   {-0.5 * w, 0.5 * h - d, 0.001},   

   {0.5 * w - d, -0.5 * h, 0.001},
   {0.5 * w, -0.5 * h + d, 0.001},   

   {-0.5 * w + d, -0.5 * h, 0.001},
   {-0.5 * w, -0.5 * h + d, 0.001}   
}

graph.observer.gear.spaces = bodies.environment {
   -- Northeast corner.

   bodies.box {
      position = {0.5 * w, 0.5 * h, 0.5 + r},
      orientation = transforms.euler (0, 0, 45),

      size = {l - 2 * r, l - 2 * r, 1},
      classification = 1
   },

   -- Northwest corner.

   bodies.box {
      position = {-0.5 * w, 0.5 * h, 0.5 + r},
      orientation = transforms.euler (0, 0, -45),

      size = {l - 2 * r, l - 2 * r, 1},
      classification = 2
   },

   -- Southeast corner.

   bodies.box {
      position = {0.5 * w, -0.5 * h, 0.5 + r},
      orientation = transforms.euler (0, 0, -45),

      size = {l - 2 * r, l - 2 * r, 1},
      classification = 3
   },

   -- Southwest corner.

   bodies.box {
      position = {-0.5 * w, -0.5 * h, 0.5 + r},
      orientation = transforms.euler (0, 0, 45),

      size = {l - 2 * r, l - 2 * r, 1},
      classification = 4
   },

   -- Everything else.

   bodies.box {
      position = {0, 0, 0.5 + r},
      orientation = transforms.euler (0, 0, 45),

      size = {L - 2 * r, L - 2 * r, 1},
      classification = 9
   },

}