/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include "texture.h"
#include "ambient.h"

#include "static.h"

@implementation Ambient

-(GLfloat *) intensityConstant
{
    return self->intensityConstant;
}

-(GLuint) intensityMap
{
    return [self->intensityMap index];
}

-(Ambient *) init
{
    [super init];

    self->intensityConstant[0] = 0;
    self->intensityConstant[1] = 0;
    self->intensityConstant[2] = 0;
    
    self->intensityMap = nil;

    return self;
}

-(void) get: (lua_State *)L
{
    const char *k;

    k = lua_tostring(L, 2);

    if (!strcmp(k, "intensity")) {
	lua_getmetatable (L, 1);
	lua_replace (L, 1);
	lua_gettable (L, 1);
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{    
    const char *k;
    int i;

    k = lua_tostring(L, 2);

    if (!strcmp(k, "intensity")) {
        if(lua_istable(L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti(L, 3, i + 1);
                self->intensityConstant[i] = lua_tonumber(L, -1);
                
                lua_pop(L, 1);
            }
	    
	    self->intensityMap = nil;
        } else if(lua_isuserdata (L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                self->intensityConstant[i] = 0;
            }
	    
	    self->intensityMap = *(id *)lua_touserdata (L, 3);
	}

	lua_getmetatable (L, 1);
	lua_replace (L, 1);
	lua_settable (L, 1);
    } else {
	[super set: L];
    }
}

@end
