/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "box.h"

@implementation Box

-(Box *) init
{
    self = [super init];

    self->geom = dCreateBox (NULL, 1, 1, 1);
    
    self->size[0] = 1;
    self->size[1] = 1;
    self->size[2] = 1;
    
    dGeomSetBody ([self geom], [self body]);

    return self;
}

-(void) get: (lua_State *)L
{
    const char *k;
    int i;
    
    k = lua_tostring(L, -1);

    if (!strcmp(k, "size")) {
        lua_newtable(L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber(L, size[i]);
            lua_rawseti(L, -2, i + 1);
        }
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{
    const char *k;
    int i;

    k = lua_tostring(L, -2);

    if (!strcmp(k, "size")) {
        if(lua_istable(L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti(L, 3, i + 1);
                size[i] = lua_tonumber(L, -1);
                
                lua_pop(L, 1);
            }
        }

	dGeomBoxSetLengths ([self geom], size[0], size[1], size[2]);
    } else {
	[super set: L];
    }
}

#if 0
-(void) traverse: (lua_State *)L
{
    GLfloat *r, *R;
    dReal *l;

    glUseProgramObjectARB(0);

    r = [self translation];
    R = [self rotation];
    l = self->size;

    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glMultMatrixf ((GLfloat[16]) {R[0], R[3], R[6], 0,
		                  R[1], R[4], R[7], 0,
		                  R[2], R[5], R[8], 0,
		                  r[0], r[1], r[2], 1});

    glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
    glEnable (GL_DEPTH_TEST);

    glColor3f (1, 0, 0);
    
    glBegin (GL_QUAD_STRIP);
    glVertex3f(-0.5 * l[0], -0.5 * l[1], -0.5 * l[2]);
    glVertex3f(-0.5 * l[0], -0.5 * l[1], 0.5 * l[2]);
    glVertex3f(-0.5 * l[0], 0.5 * l[1], -0.5 * l[2]);
    glVertex3f(-0.5 * l[0], 0.5 * l[1], 0.5 * l[2]);

    glVertex3f(0.5 * l[0], 0.5 * l[1], -0.5 * l[2]);
    glVertex3f(0.5 * l[0], 0.5 * l[1], 0.5 * l[2]);
 
    glVertex3f(0.5 * l[0], -0.5 * l[1], -0.5 * l[2]);
    glVertex3f(0.5 * l[0], -0.5 * l[1], 0.5 * l[2]);
       
    glVertex3f(-0.5 * l[0], -0.5 * l[1], -0.5 * l[2]);
    glVertex3f(-0.5 * l[0], -0.5 * l[1], 0.5 * l[2]);

    glEnd();

    glDisable (GL_DEPTH_TEST);
    glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);

    glPopMatrix();

    [super traverse: L];
}
#endif

@end
