/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>

#include "container.h"

@implementation Container

-(Container *) init
{
    self = [super init];
    
    self->padding[0] = 0;
    self->padding[1] = 0;

    self->align = 0;
    
    return self;
}
    
-(void) get: (lua_State *)L
{
    const char *k;
    int i;

    k = lua_tostring(L, 2);

    if (!strcmp(k, "padding")) {
        lua_newtable(L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber(L, self->padding[i]);
            lua_rawseti(L, -2, i + 1);
        }
    } else if (!strcmp(k, "align")) {
	lua_pushnumber (L, self->align);
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{    
    const char *k;
    int i;

    k = lua_tostring(L, 2);

    if (!strcmp(k, "padding")) {
        if(lua_istable(L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti(L, 3, i + 1);
                self->padding[i] = lua_tonumber(L, -1);
                
                lua_pop(L, 1);
            }
        }
    } else if (!strcmp(k, "align")) {
	self->align = lua_tonumber (L, -1);
    } else {
	[super set: L];
    }
}

@end

