/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fog.h"

@implementation Fog

-(Fog *)init
{
    [super init];
    
    self->offset = 0;

    self->densityConstant[0] = 0;
    self->densityConstant[1] = 0;

    self->colorConstant[0] = 1;
    self->colorConstant[1] = 1;
    self->colorConstant[2] = 1;

    return self;
}

-(float) offset
{
    return self->offset;
}

-(float *) densityConstant
{
    return self->densityConstant;
}

-(float *) colorConstant
{
    return self->colorConstant;
}

-(void) get: (lua_State *)L
{
    const char *k;
    int i;

    k = lua_tostring(L, 2);

    if (!strcmp(k, "linear")) {
	lua_pushnumber (L, self->densityConstant[0]);
    } else if (!strcmp(k, "quadratic")) {
	lua_pushnumber (L, self->densityConstant[1]);
    } else if (!strcmp(k, "offset")) {
	lua_pushnumber (L, self->offset);
    } else if (!strcmp(k, "color")) {
	lua_newtable(L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber(L, self->colorConstant[i]);
            lua_rawseti(L, -2, i + 1);
        }
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{    
    const char *k;
    int i;

    k = lua_tostring(L, 2);

    if (!strcmp(k, "linear")) {
	self->densityConstant[0] = lua_tonumber(L, 3);
    } else if (!strcmp(k, "quadratic")) {
	self->densityConstant[1] = lua_tonumber(L, 3);
    } else if (!strcmp(k, "offset")) {
	self->offset = lua_tonumber(L, 3);
    } else if (!strcmp(k, "color")) {
        if(lua_istable(L, 3)) {
            for(i = 0 ; i < 4 ; i += 1) {
                lua_rawgeti(L, 3, i + 1);
                self->colorConstant[i] = lua_tonumber(L, -1);
                
                lua_pop(L, 1);
            }
        }
    } else {
	[super set: L];
    }
}

@end
