/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "joint.h"
#include "body.h"

static dWorldID world;

@implementation Joint

-(dWorldID) world
{
    if (!world) {
	id node;

	node = [Node alloc];
	world = [node world];
	[node free];
    }

    return world;
}

-(dJointID) joint
{
    return self->joint;
}

-(void) free
{
    dJointDestroy (self->joint);
    
    [super free];
}

-(void) get: (lua_State *)L
{
    const char *k;
    
    k = lua_tostring(L, -1);

    if (!strcmp(k, "bodies")) {
	lua_getmetatable (L, -2);
	lua_replace (L, -3);
	lua_gettable (L, -2);
	    
	if (lua_isnil(L, -1)) {
	    lua_newtable(L);
	}
    }
}

-(void) set: (lua_State *)L
{
    id a, b;
    const char *k;

    k = lua_tostring(L, -2);

    if (!strcmp(k, "bodies")) {
	if(lua_istable(L, 3)) {
	    lua_rawgeti (L, 3, 1);
	    if(lua_isuserdata (L, -1)) {
		a = (*(id *)lua_touserdata(L, -1));
	    } else {
		a = nil;
	    }

	    lua_rawgeti (L, 3, 2);
	    if(lua_isuserdata (L, -1)) {
		b = (*(id *)lua_touserdata(L, -1));
	    } else {
		b = nil;
	    }

	    lua_pop (L, 2);
	    
	    lua_getmetatable (L, 1);
	    lua_pushvalue (L, 2);
	    lua_pushvalue (L, 3);
	    lua_settable (L, -3);
	    lua_pop (L, 1);

	    dJointAttach([self joint], [a body], [b body]);
	}
    }
}

@end
