/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "observer.h"

@implementation Observer

-(Observer *) init
{
    [super init];
    
    self->node = nil;

    return self;
}

-(void) transform: (lua_State *)L
{
    if (self->node) {
	GLfloat *r, *R;
	GLfloat M[16];

	r = [self->node translation];
	R = [self->node rotation];

	glMatrixMode (GL_MODELVIEW);
	glPushMatrix ();
	glLoadIdentity ();

	gluLookAt (r[0], r[1], r[2],
		   r[0] - R[2], r[1] - R[5], r[2] - R[8],
		   -R[0], -R[3], -R[6]);

	glGetFloatv (GL_MODELVIEW_MATRIX, M);

	self->position[0] = M[12];
	self->position[1] = M[13];
	self->position[2] = M[14];
	
	self->orientation[0] = M[0];
	self->orientation[1] = M[4];
	self->orientation[2] = M[8];

	self->orientation[3] = M[1];
	self->orientation[4] = M[5];
	self->orientation[5] = M[9];

	self->orientation[6] = M[2];
	self->orientation[7] = M[6];
	self->orientation[8] = M[10];

	glPopMatrix();
    }
    
    [super transform: L];
}

-(void) get: (lua_State *)L
{
    const char *k;
    
    k = lua_tostring(L, 2);

    if (!strcmp(k, "node")) {
	lua_getmetatable (L, 1);
	lua_replace (L, 1);
	lua_gettable (L, 1);
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{
    const char *k;

    k = lua_tostring(L, 2);

    if (!strcmp(k, "node")) {
	if (!lua_isnil(L, 3)) {
	    self->node = *(id *)lua_touserdata(L, 3);
	} else {
	    self->node = nil;
	}
	
	lua_getmetatable (L, 1);
	lua_replace (L, 1);
	lua_settable (L, 1);
    } else {
	[super set: L];
    }
}

@end
