/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <AL/al.h>
#include "waveform.h"

@implementation Waveform

-(Waveform *) init
{
    [super init];

    self->size = 0;
    self->name = 0;

    return self;
}

-(Waveform *) initWithSamples: (ALshort *) samples
                       ofSize: (int) n
	          atFrequency: (int) f;
{
    ALenum error;
    ALuint b;

    [super init];
        
    alGetError();

    alGenBuffers(1, &b);
    alBufferData (b, AL_FORMAT_MONO16, samples, n, f);

    error = alGetError();
    if(error != AL_NO_ERROR) {
	printf ("Could not create waveform (%s).\n", alGetString(error));
    }
    
    self->name = b;
    self->size = n;
    self->frequency = f;
 
    return self;
}

-(void) free
{
    alDeleteBuffers(1, &self->name);

    [super free];
}

-(int) length
{
    return self->size;
}

-(int) frequency
{
    return self->frequency;
}

-(ALuint) index
{
    return self->name;
}

@end
