/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ctype.h>
#include <string.h>
#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>

#include "face.h"
#include "string.h"
#include "display.h"
#include "column.h"
#include "row.h"
#include "frame.h"

static char *decapitalize (char *s)
{
    s[0] = tolower(s[0]);

    return s;
}

static int node_tostring(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);
    lua_pushstring(L, [N name]);
   
    return 1;
}

static int node_index(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);
    
    [N get: L];
    
    return 1;
}

static int node_newindex(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);
    
    [N set: L];

    return 0;
}

static int node_gc(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);

    [N free];

    return 0;
}

static int string_gc(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);

    [N freeTexture];
    [N free];

    return 0;
}

static int string_tostring(lua_State *L)
{
    lua_pushvalue(L, lua_upvalueindex(1));
    return 1;
}

static int string_call (lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);

    /* Create the userdata... */
	
    *(id *)lua_newuserdata(L, sizeof(id)) = [N copy];
    
    lua_newtable (L);
    lua_pushstring(L, "__index");
    lua_pushcfunction(L, node_index);
    lua_settable(L, -3);
    lua_pushstring(L, "__newindex");
    lua_pushcfunction(L, node_newindex);
    lua_settable(L, -3);
    lua_pushstring(L, "__tostring");
    lua_pushcfunction(L, node_tostring);
    lua_settable(L, -3);
    lua_pushstring(L, "__gc");
    lua_pushcfunction(L, node_gc);
    lua_settable(L, -3);
    lua_pushstring(L, "__reference");
    lua_pushvalue(L, 1);
    lua_settable(L, -3);
    lua_setmetatable(L, -2);
    
    /* ...and initialize it. */

    if(lua_istable(L, 2)) {
	lua_pushnil(L);
	
	while(lua_next(L, 2)) {
	    lua_pushvalue(L, -2);
	    lua_insert(L, -2);
	    lua_settable(L, 3);
	}
    }

    return 1;
}

static int face_call(lua_State *L)
{
    id N, string;
    const char *text;

    N = *(id *)lua_touserdata(L, 1);
    text = luaL_checkstring (L, 2);

    string = [N layoutString: text];
    *(id *)lua_newuserdata(L, sizeof(id)) = string;

    lua_newtable(L);
    lua_pushstring(L, "__tostring");
    lua_pushvalue(L, 2);
    lua_pushcclosure(L, string_tostring, 1);
    lua_settable(L, -3);
    lua_pushstring(L, "__call");
    lua_pushcfunction(L, string_call);
    lua_settable(L, -3);
    lua_pushstring(L, "__gc");
    lua_pushcfunction(L, string_gc);
    lua_settable(L, -3);
    lua_setmetatable(L, -2);
   
    return 1;
}

static int constructface (lua_State *L)
{
    id object;
    const char *name;

    name = luaL_checkstring (L, 1);
    
    /* Create the userdata... */

    object = [[Face alloc] initFromFile: name];

    if(object) {
	*(id *)lua_newuserdata(L, sizeof(id)) = object;
    
	lua_newtable (L);
	lua_pushstring(L, "__call");
	lua_pushcfunction(L, (lua_CFunction)face_call);
	lua_settable(L, -3);
	lua_pushstring(L, "__tostring");
	lua_pushcfunction(L, (lua_CFunction)node_tostring);
	lua_settable(L, -3);
	lua_pushstring(L, "__gc");
	lua_pushcfunction(L, (lua_CFunction)node_gc);
	lua_settable(L, -3);
	lua_setmetatable(L, -2);
    
	/* ...and initialize it. */

	if(lua_istable(L, 1)) {
	    lua_pushnil(L);
	
	    while(lua_next(L, 1)) {
		lua_pushvalue(L, -2);
		lua_insert(L, -2);
		lua_settable(L, 2);
	    }
	}
    } else {
	lua_pushnil(L);
    }

    return 1;
}

static int constructnode (lua_State *L)
{
    Class class;
    id object;

    lua_pushvalue (L, lua_upvalueindex (1));
    class = (Class)lua_touserdata(L, -1);
    lua_pop(L, 1);

    /* Create the userdata... */

    object = [[class alloc] init];
    *(id *)lua_newuserdata(L, sizeof(id)) = object;
    
    lua_newtable (L);
    lua_pushstring(L, "__index");
    lua_pushcfunction(L, (lua_CFunction)node_index);
    lua_settable(L, -3);
    lua_pushstring(L, "__newindex");
    lua_pushcfunction(L, (lua_CFunction)node_newindex);
    lua_settable(L, -3);
    lua_pushstring(L, "__tostring");
    lua_pushcfunction(L, (lua_CFunction)node_tostring);
    lua_settable(L, -3);
    lua_pushstring(L, "__gc");
    lua_pushcfunction(L, (lua_CFunction)node_gc);
    lua_settable(L, -3);
    lua_setmetatable(L, -2);
    
    /* ...and initialize it. */

    if(lua_istable(L, 1)) {
	lua_pushnil(L);
	
	while(lua_next(L, 1)) {
	    lua_pushvalue(L, -2);
	    lua_insert(L, -2);
	    lua_settable(L, 2);
	}
    }

    return 1;
}

int luaopen_widgets (lua_State *L)
{
    int i;
    
    Class nodes[] = {
	[Display class], [Frame class], [Column class], [Row class]
    };	

    lua_newtable (L);
    
    for (i = 0 ; i < sizeof(nodes) / sizeof(nodes[0]) ; i += 1) {
	lua_pushlightuserdata (L, nodes[i]);
	lua_pushcclosure (L, constructnode, 1);
	lua_setfield(L, -2, decapitalize(strdupa([nodes[i] name])));
    }

    lua_pushcfunction (L, constructface);
    lua_setfield (L, -2, "face");

    lua_setglobal (L, lua_tostring (L, 1));

    return 0;
}
