-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"
require "moremath"

print "\nLoading the http server pages."

network.mime["/stylesheet"] = "text/css"
network.pages["/stylesheet"] = resources.readfile "scripts/pages/stylesheet.lua"

network.mime["/test"] = "text/html"
network.pages["/test"] = resources.readfile "scripts/pages/test.lua"

network.mime["/settings"] = "text/html"
network.pages["/settings"] = resources.readfile "scripts/pages/settings.lua"

network.mime["/history"] = "text/html"
network.pages["/history"] = resources.readfile "scripts/pages/history.lua"

network.mime["/logo"] = "image/svg+xml"
network.pages["/logo"] = resources.readfile "scripts/pages/logo.lua"

network.pages["/"] = resources.readfile "scripts/pages/default.lua"
network.mime["/"] = "text/html"

network.pages["/newgame"] = resources.readfile "scripts/pages/newgame.lua" 
network.mime["/newgame"] = "text/html"

network.pages["/setvalue"] = resources.readfile "scripts/pages/setvalue.lua" 
network.mime["/setvalue"] = "text/html"

if options.pool then
   network.pages["/drawtable"] = resources.readfile "scripts/pages/drawpool.lua"
elseif options.billiards then
   network.pages["/drawtable"] = resources.readfile "scripts/pages/drawbilliards.lua"
end

network.mime["/drawtable"] = "image/svg+xml"

-- Shot diagrams.

billiards.looking.traceballs = function ()
   for _, ball in ipairs (bodies.balls) do
      ball.trajectory = {ball.position}
      ball.arclength = 1/0
   end

   graph.gear.transform = nil
end

billiards.waiting.traceballs = function ()
   graph.gear.transform = function ()
      for _, ball in ipairs (bodies.balls) do
	 if not ball.ispocketed then
	    local S_0 = ball.arclength
	    local S = math.distance (ball.position,
				     ball.trajectory[#ball.trajectory])
	    local C = math.distance (ball.position,
				     ball.trajectory[#ball.trajectory - 1]) 

	    if 0.5 * math.sqrt((S_0 + S) * (S_0 + S) - C * C) > 0.002 then
	       ball.arclength = S
	    else
	       table.remove (ball.trajectory)
	       ball.arclength = S_0 + S
	    end

	    table.insert (ball.trajectory, ball.position)
	 end
      end
   end
end

-- Shot history.

billiards.striking.snapshot = function ()
   local shot = {}

   -- Save the shot trajectories.

   for _, ball in ipairs (bodies.balls) do
      table.insert(shot, ball.trajectory)
   end

   table.insert (billiards.history, shot)

   -- Draw a snapshot.

--    network.pages["/drawshot" .. #billiards.history] =
--       string.gsub(network.pages["/drawtable"],
-- 		  "<%?lua(.-)%?>",
-- 		  function (string)
-- 		     return assert(loadstring(string))()
-- 		  end)
--    network.mime["/drawshot" .. #billiards.history] = "image/svg+xml"
end