<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Shots</title>
  <link rel="stylesheet" href="stylesheet">

  <style type="text/css">
    col.first {width : 12em;}
    col.second {width : 7em ;}
  </style>
</head>

<body>
  <hr> 
  <h1>
    <object height=85 type="image/svg+xml" data="/logo">Billiards</object>
  </h1>
  
  <a href="/history">refresh</a>
  &middot;
  <a href = "/">back</a>
  <hr> 

      <?lua
      local html = ""
      local n

      if query then
	 if query.backtrackto then
	    local opening

	    query.backtrackto = tonumber(query.backtrackto)

	    for _ = 1, #billiards.history - query.backtrackto + 1 do
	       opening = table.remove(billiards.history)
	    end

	    for i, line in ipairs (opening) do
	       billiards.opening[i] = line[1]
	    end
	    
	    -- Restart.

	    resources.dofile "scripts/restart.lua"
	 end
      end

      if #billiards.history > 0 then
	 html = [[

  <p>
    Here's a list of the shots made so far.  Use the
    <a href="/history">refresh</a> link to bring it up to date.
  </p>
  
  <table>

    <col class="first">
    <col class="second">
    <col class="third">

    <tr><th colspan="3"> Shot history
	 ]]
      else
	 html = [[

  <p>  No shots have been made so far. </p>
	 ]]
      end

      n = #billiards.history

      -- List all shots.

      for i = 1, n do
	 html = html .. string.format([[

        <tr class="%s">
        <td>%d
        <td><object height=100 type="image/svg+xml"
                     data="/drawtable?shot=%d">SVG</object>
	<td style="width : 100%% ; height : 100%%">
          <div>
            <a href="/drawtable?shot=%d">view</a><br>
            <a href="/history?backtrackto=%d">backtrack</a><br>
				      ]], math.mod(i, 2) == 1 and
				          "even" or "odd",
				          i, i, i, i)
      end

      if #billiards.history > 0 then
	 html = html .. [[
    </table>
	 ]]
      end

      return html
    ?>
  <hr> 
</body>
