/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glx.h>
#include "button.h"

static int indices[256];
static int sample, done;

@implementation Button

-(Button *) init
{
    int i;
    
    self = [super init];

    for (i = 0 ; i < 256 && indices[i] ; i += 1);
    indices[i] = 1;

    self->state = 0;
    self->index = i;    
    self->selected = LUA_REFNIL;
    
    return self;
}

-(void) free
{
    indices[self->index] = 0;

    [super free];
}

-(void) traverse
{
    done = 0;

    glEnable (GL_STENCIL_TEST);
    glStencilFunc (GL_ALWAYS, self->index, 0xff);
    glStencilOp (GL_KEEP, GL_KEEP, GL_REPLACE);
    
    [super traverse];

    glStencilFunc (GL_ALWAYS, 0, 0xff);
    glDisable (GL_STENCIL_TEST);
}

-(void) cleanup
{
    Display *display;
    Window window, root, child;
    GLint viewport[4];
    unsigned int mask;
    int x, y, u, v;

    display = glXGetCurrentDisplay();
    window = glXGetCurrentDrawable();

    glGetIntegerv (GL_VIEWPORT, viewport);
    XQueryPointer (display, window, &root, &child, &u, &v, &x, &y, &mask);
	
    [super cleanup];

    if (!done && mask >> 8 == 0) {
	/* Sample the stencil buffer. */

	glReadPixels (x, viewport[3] - y, 1, 1,
		      GL_STENCIL_INDEX,
		      GL_UNSIGNED_INT, &sample);
/* 	printf ("%d, %d\n", sample, mask >> 8); */
    }

    if (sample == self->index && !self->state) {
	if (self->selected != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->selected);
	    lua_pushliteral (_L, "parent");

	    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
	    lua_pushlightuserdata (_L, self);
	    lua_gettable (_L, -2);
	    lua_replace (_L, -2);

	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
	
	self->state = 1;
    }

    if (sample != self->index && self->state) {
	if (self->selected != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->selected);
	    lua_pushliteral (_L, "parent");
	    lua_pushnil (_L);
	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
	
	self->state = 0;
    }
}

-(void) get
{
    const char *k;
    
    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "selected")) {
        lua_rawgeti (_L, LUA_REGISTRYINDEX, self->selected);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "selected")) {
	/* Make sure we're unlinked. */
	
	if (self->selected != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->selected);
	    lua_pushliteral (_L, "parent");
	    lua_pushnil (_L);
	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
	
        luaL_unref (_L, LUA_REGISTRYINDEX, self->selected);
        self->selected = luaL_ref (_L, LUA_REGISTRYINDEX);

	/* Link if needed. */
	
	if (self->state > 0 && self->selected != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->selected);
	    lua_pushliteral (_L, "parent");

	    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
	    lua_pushlightuserdata (_L, self);
	    lua_gettable (_L, -2);
	    lua_replace (_L, -2);

	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
    } else {
	[super set];
    }
}

@end
