/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <ctype.h>
#include "event.h"

static int x_0, y_0;

@implementation Event

-(Event *) init
{
    [super init];

    self->buttonpress = LUA_REFNIL;
    self->buttonrelease = LUA_REFNIL;
    self->keypress = LUA_REFNIL;
    self->keyrelease = LUA_REFNIL;
    self->motion = LUA_REFNIL;

    return self;
}

-(void) toggle
{
    Display *display;
    XEvent event;

    display = glXGetCurrentDisplay();
    
    [super toggle];

    while (XCheckMaskEvent(display,
			   ButtonPressMask | ButtonReleaseMask |
			   KeyPressMask | KeyReleaseMask |
			   PointerMotionMask,
			   &event));
}

-(void) cleanup
{
    Display *display;
    XEvent event;

    display = glXGetCurrentDisplay();

    /* Check for window system events and
       fire the relevant bindings. */
	
    while (XCheckMaskEvent(display,
			   ButtonPressMask | ButtonReleaseMask |
			   KeyPressMask | KeyReleaseMask |
			   PointerMotionMask,
			   &event)) {
	int i, h_0, h_1;

	h_0 = lua_gettop (_L) + 1;

	if (event.type == ButtonPress ||
	    event.type == ButtonRelease) {
	    if (event.type == ButtonPress) {
		lua_rawgeti (_L, LUA_REGISTRYINDEX, self->buttonpress);
	    } else {
		lua_rawgeti (_L, LUA_REGISTRYINDEX, self->buttonrelease);
	    }
		
	    lua_pushnumber (_L, event.xbutton.button);
	    lua_pushnumber (_L, event.xbutton.x);
	    lua_pushnumber (_L, event.xbutton.y);
	    lua_pushnumber (_L, event.xmotion.x - x_0);
	    lua_pushnumber (_L, event.xmotion.y - y_0);
	} else if (event.type == MotionNotify) {
	    int i;
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, motion);

	    for (i = 0 ; (1 << i) - 1 < event.xmotion.state >> 8 ; i += 1);

	    if (i > 0) {
		lua_pushnumber (_L, i);
	    } else {
		lua_pushnil(_L);
	    }
		
	    lua_pushnumber (_L, event.xmotion.x);
	    lua_pushnumber (_L, event.xmotion.y);
	    lua_pushnumber (_L, event.xmotion.x - x_0);
	    lua_pushnumber (_L, event.xmotion.y - y_0);
		
	    x_0 = event.xmotion.x;
	    y_0 = event.xmotion.y;
	} else if (event.type == KeyPress ||
		   event.type == KeyRelease) {
	    KeySym sym;
	    char *s;
	    int i;

	    XLookupString (&event.xkey, NULL, 0, &sym, NULL);

	    if (event.type == KeyPress) {
		lua_rawgeti (_L, LUA_REGISTRYINDEX, self->keypress);
	    } else {
		lua_rawgeti (_L, LUA_REGISTRYINDEX, self->keyrelease);
	    }
		
	    s = strdup(XKeysymToString (sym));

	    /* Convert all strings to lowercase to
	       make things more consistent. */
		    
	    for (i = 0 ; i < strlen (s) ; i += 1) {
		s[i] = tolower(s[i]);
	    }

	    lua_pushstring (_L, s);
	    free(s);
	}

	lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
	lua_pushlightuserdata (_L, self);
	lua_gettable (_L, -2);
	lua_insert (_L, h_0 + 1);
	lua_pop (_L, 1);

	h_1 = lua_gettop (_L);
	    
	if (lua_isfunction (_L, h_0)) {
	    lua_call (_L, h_1 - h_0, 0);
	} else if (lua_istable (_L, h_0)) {
	    lua_pushnil (_L);
	    while (lua_next (_L, h_0) != 0) {
		for (i = 0 ; i < h_1 - h_0 ; i += 1) {
		    lua_pushvalue (_L, h_0 + i + 1);
		}

		lua_call (_L, h_1 - h_0, 0);
	    }
	}

	lua_settop (_L, h_0 - 1);
    }    
    
    [super cleanup];
}

-(void) get
{
    const char *k;

    k = lua_tostring(_L, 2);
    
    if (!xstrcmp(k, "buttonpress")) {
	lua_rawgeti(_L, LUA_REGISTRYINDEX, self->buttonpress);
    } else if (!xstrcmp(k, "buttonrelease")) {
	lua_rawgeti(_L, LUA_REGISTRYINDEX, self->buttonrelease);
    } else if (!xstrcmp(k, "keypress")) {
	lua_rawgeti(_L, LUA_REGISTRYINDEX, self->keypress);
    } else if (!xstrcmp(k, "keyrelease")) {
	lua_rawgeti(_L, LUA_REGISTRYINDEX, self->keyrelease);
    } else if (!xstrcmp(k, "motion")) {
	lua_rawgeti(_L, LUA_REGISTRYINDEX, motion);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring(_L, 2);
    
    if (!xstrcmp(k, "buttonpress")) {
	luaL_unref (_L, LUA_REGISTRYINDEX, self->buttonpress);
	self->buttonpress = luaL_ref (_L, LUA_REGISTRYINDEX);
    } else if (!xstrcmp(k, "buttonrelease")) {
	luaL_unref (_L, LUA_REGISTRYINDEX, self->buttonrelease);
	self->buttonrelease = luaL_ref (_L, LUA_REGISTRYINDEX);
    } else if (!xstrcmp(k, "keypress")) {
	luaL_unref (_L, LUA_REGISTRYINDEX, self->keypress);
	self->keypress = luaL_ref (_L, LUA_REGISTRYINDEX);
    } else if (!xstrcmp(k, "motion")) {
	luaL_unref (_L, LUA_REGISTRYINDEX, motion);
	motion = luaL_ref (_L, LUA_REGISTRYINDEX);
    } else if (!xstrcmp(k, "keyrelease")) {
	luaL_unref (_L, LUA_REGISTRYINDEX, self->keyrelease);
	self->keyrelease = luaL_ref (_L, LUA_REGISTRYINDEX);
    } else {
	[super set];
    }
}

@end
