#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "halo.h"

@implementation Halo

-(Halo *) init
{
    [super init];
    
    self->color[0] = 0;
    self->color[1] = 0;
    self->color[2] = 0;
    self->color[3] = 1;

    self->width = 1;
    
    return self;
}
    
-(void) get
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!strcmp(k, "color")) {
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->color[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!strcmp(k, "width")) {
	lua_pushnumber (_L, self->width);
    } else if (!xstrcmp(k, "opacity")) {
	lua_pushnumber (_L, self->color[3]);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!strcmp(k, "color")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->color[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else if (!xstrcmp(k, "opacity")) {
	self->color[3] = lua_tonumber (_L, 3);
    } else if (!strcmp(k, "width")) {
	self->width = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

-(void) traverse
{
    [super deferTraversal];
}

-(void) traverseDeferred
{
    glDepthMask(GL_FALSE);
    glEnable (GL_DEPTH_TEST);
    glEnable (GL_CULL_FACE);

    glCullFace (GL_FRONT);
    glColorMask (GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);

    [super traverse];

    glColorMask (GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
    glUseProgramObjectARB (0);

    glEnable (GL_LINE_SMOOTH);
    glEnable (GL_POLYGON_OFFSET_LINE);
    glEnable (GL_BLEND);

    glPolygonOffset (1, 1);
    glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);    
    
    glLineWidth (self->width);
    glColor4fv (self->color);

    [super traverse];

    glCullFace (GL_BACK);
    glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);

    glDisable (GL_BLEND);
    glDisable (GL_POLYGON_OFFSET_LINE);
    glDisable (GL_LINE_SMOOTH);
    glDisable (GL_CULL_FACE);
    glDisable (GL_DEPTH_TEST);
    glDepthMask(GL_TRUE);
}

@end

