/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glext.h>

#include "texture.h"
#include "oren.h"
#include "light.h"

static GLuint name;
static const GLchar *vertexSource =
"varying vec3 vertex, vertexNormal;    				   	   \n"
"varying vec2 terms[maxLightCount];   	     				   \n"
"				   		     			   \n"
"void main() 			   		     			   \n"
"{		 		   		     			   \n"
"    vertex = vec3(gl_ModelViewMatrix * gl_Vertex);			   \n"
"    vertexNormal = gl_NormalMatrix * gl_Normal;			   \n"
"				   		     			   \n"
"    gl_Position = ftransform();	     				   \n"
"    gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;	   	   \n"
"}		 		   		     			   \n";

static const GLchar *fragmentSource = 
"varying vec3 vertex, vertexNormal;  	  			   	   \n"
"				   		     			   \n"
"void main()                            	     			   \n"
"{	                                	     			   \n"
"    vec3 eye, normal, diffuse, sum;					   \n"
"    vec2 coefficients;							   \n"
"    float sigma, A, B, ndote, theta;				   	   \n"
"    int i;								   \n"
"			   		     				   \n"
"    diffuse = vec3(diffuseSum(gl_TexCoord[0].st));	   		   \n"
"    sigma = float(parameterSum(gl_TexCoord[0].st));	   		   \n"
"				   		     			   \n"
"    A = 1.0 - 0.5 * sigma / (sigma + 0.33);		   		   \n"
"    B = 0.45 * sigma / (sigma + 0.09);			   	   	   \n"
"				   		     			   \n"
"    normal = normalize(vertexNormal);					   \n"
"    eye = normalize(-vertex);   				   	   \n"
"				   		     			   \n"
"    ndote = dot(normal, eye);           				   \n"
"    theta = acos(ndote);	   		     			   \n"
"				   		     			   \n"
"    for (i = 0, sum = vec3(0) ; i < lightCount ; i += 1) { 	   	   \n"
"        vec3 light;						   	   \n"
"        float ndotl, phi, alpha, beta, C;		   		   \n"
"				   		     			   \n"
"        light = normalize(lightSources[i].position - vertex); 		   \n"
"        ndotl = dot(normal, light);     				   \n"
"        phi = acos(ndotl);	 	     				   \n"
"				   		     			   \n"
"        alpha = max(theta, phi);  		     			   \n"
"        beta = min(theta, phi);   	     				   \n"
"				   		     			   \n"
"        C = max(0.0, dot(normalize(eye - ndote * normal),	   	   \n"
"                         normalize(light - ndotl * normal)));	   	   \n"
"				   		     			   \n"
"        sum += luminousIntensity(lightSources[i], light) *   	   	   \n"
"               shadowFactor (lightSources[i], vertex) *		   \n"
"               attenuationFactor (lightSources[i], vertex) *		   \n"
"               max(ndotl, 0.0) * (A + B * sin(alpha) * tan(beta) * C);    \n" 
"    }				   		     			   \n"
"				   		     			   \n"
"    if (hasAmbience) {		   		     			   \n"
"        sum += diffuse * ambientIntensity(normal);   	   		   \n"
"    }				   		     			   \n"
"				   		     			   \n"
"    gl_FragColor = vec4(befog (sum * diffuse, vertex), 1.0);		   \n"
"}                                      	     			   \n";

@implementation Oren

-(Oren *)init
{
    if (!name) {
	[self build];
	[self verify];

	name = self->program;
    } else {
	self->program = name;
    }

    [super init];
    
    return self;
}

-(void) build
{
    [super build];
    
    [self attachVertexSource: vertexSource];
    [self attachFragmentSource: fragmentSource];
    [self link];
}
    
-(void)traverse
{
    glUseProgramObjectARB(self->program);
    glActiveTexture (GL_TEXTURE0);
	    
    [super traverse];
}

@end
