-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"
require "resources"
require "derived"

function callhooks (hooks, ...)
   if type (hooks) == "table" then
      for _, hook in pairs(hooks) do
	 if ... and type(...) == "table" then
	    hook (unpack(...))
	 else
	    hook (...)
	 end
      end
   elseif type (hooks) == "function" then
      if ... and type(...) == "table" then
	 hooks(unpack(...))
      else
	 hooks (...)
      end
   end
end

graphics.close = function ()
		    common.iterate = false
		 end

-- Right now full shading only works on 'certain' GPUs.
-- The rest will have to do with fixed-pipeline toon
-- shading.

-- print (graphics.vendor, string.find (graphics.vendor, "N1VIDIA")); abort();

if not options.notoon and
   (not string.find (graphics.vendor, "NVIDIA") or
    not string.find (graphics.extensions, "fragment_shader")) then
   print ("I'm going to take a wild guess that your card doesn't " .. 
	  "support full\n shading so I'm falling back to toon mode. " ..
	  "Override with -Onotoon.\n")
   options.toon = true
end

-- These values are fixed.

graphics.title = "Billiards"
graphics.perspective = {-1, 1, -1, 1, 0.01, 20}
graphics.canvas = options.toon and {0.7, 0.7, 0.6} or {0.07, 0.07, 0.075}

dynamics.collision = {}

billiards = {}
billiards.waiting = {}
billiards.looking = {}
billiards.aiming = {}
billiards.ballcollision = {}
billiards.cushioncollision = {}
billiards.cuecollision = {}
billiards.striking = {}
billiards.turning = {}
billiards.zooming = {}
billiards.panning = {}
billiards.reorienting = {}
billiards.adjusting = {}
billiards.grabbing = {}
billiards.releasing = {}
billiards.opening = {}
billiards.history = {}

bindings = {}

-- Load the default configuration.

resources.dofile "billiards/defaults.lua"
resources.dofile "billiards/resources.lua"
resources.dofile "billiards/billiard.lua"

if not (options.eightball or
	options.nineball or
	options.carom or
	options.experiment) then
   options.eightball = true
end

if options.eightball or
   options.nineball then
   options.pool = true
elseif options.carom or
   options.experiment then
   options.billiards = true
end

-- Load per-user configuration.

print "Reading local user configuration."

local rcscript = loadfile (os.getenv ("HOME") .. "/.billiards")

if rcscript then
   print ("  " .. os.getenv ("HOME") .. "/.billiards")
   rcscript ()
else
   local defaultsfile, rcfile, error

   print "Creating user configuration with default values."

   -- If none exists create one by copying the faults.

   defaultsfile = io.open ("billiards/defaults.lua", "r")
   rcfile, error = io.open (os.getenv ("HOME") .. "/.billiards", "w")

   if defaultsfile and rcfile then
      local defaults

      defaults = defaultsfile:read "*a"
      rcfile:write (defaults)
   else
      print (error)
   end

   io.close (defaultsfile)
   io.close (rcfile)
end

resources.dofile "billiards/experiment.lua"
resources.dofile "billiards/collision.lua"
resources.dofile "billiards/observer.lua"
resources.dofile "billiards/room.lua"
resources.dofile "billiards/cue.lua"
resources.dofile "billiards/rack.lua"
resources.dofile "billiards/game.lua"
resources.dofile "billiards/display.lua"
resources.dofile "billiards/httpd.lua"

graph.message.lines[1] = "If you're wondering where the GUI is, it's web-based!"
graph.message.lines[2] = "Visit http://127.0.0.1:29176 with your favorite browser."

-- resources.dofile "billiards/sounds.lua"

-- billiards.striking.slow = function()
-- 				dynamics.timescale = 0.25
-- 			     end

-- common.iterate = false
