#-------------------------------------------------
#
# Project created by QtCreator 2019-04-05T14:36:01
#
#-------------------------------------------------



greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

equals(QT_MAJOR_VERSION,4) {
   message("QT4 used")
}
equals(QT_MAJOR_VERSION,5) {
   message("QT5 used")
}

QT       += core gui

VERSION     = 0.1.0
TARGET = speckleonline
TEMPLATE    = app

INCLUDEPATH += include
################################################################################


RESOURCES +=  $${TARGET}.qrc

RC_FILE = $${TARGET}.rc
DESTDIR=bin
CONFIG += release
CONFIG += c++11

INCLUDEPATH += include

################################################################################
win32{

    OPENCV_WIN_DLL_PATH="C:/OpenCV3.x/install/x64/mingw/bin"
    OPENCV_WIN_INCLUDE_PATH="C:/OpenCV3.x/install/include"

    message("We are asuming that OpenCV libs are located in $$OPENCV_WIN_DLL_PATH")

    LIBS += -lopencv_calib3d346
    LIBS += -lopencv_core346
    LIBS += -lopencv_dnn346
    LIBS += -lopencv_features2d346
    LIBS += -lopencv_flann346
    LIBS += -lopencv_highgui346
    LIBS += -lopencv_imgcodecs346
    LIBS += -lopencv_imgproc346
    LIBS += -lopencv_ml346
    LIBS += -lopencv_objdetect346
    LIBS += -lopencv_photo346
    LIBS += -lopencv_shape346
    LIBS += -lopencv_stitching346
    LIBS += -lopencv_superres346
    LIBS += -lopencv_video346
    LIBS += -lopencv_videoio346
    LIBS += -lopencv_videostab346
#    LIBS += -lopencv_ffmpeg346

    LIBS += -L$$OPENCV_WIN_DLL_PATH
    INCLUDEPATH += $$OPENCV_WIN_INCLUDE_PATH

    DEFINES += __OS_WINDOWS__

    isEmpty(PREFIX) {
        PREFIX = c:\usr\local
        message(" ")
        message("The current 'make install' path is $$PREFIX, to change write: qmake PREFIX=/another/path")
    }
}


unix{
    packagesExist(opencv){EXIST_OPENCV="true"}
    isEmpty(EXIST_OPENCV){error("OpenCV is not installed. Try: sudo apt-get install libopencv-dev")}

    CONFIG += link_pkgconfig
    PKGCONFIG += opencv
    DEFINES += __OS_UNIX__


    isEmpty(PREFIX) {
        PREFIX = /usr/local
        message("")
        message("To change the current 'make install' path, write: qmake PREFIX=/another/path")
    }
    message("The current 'make install' path is $$PREFIX")
    
}


################################################################################

# The following define makes your compiler emit warnings if you use
# any feature of Qt which has been marked as deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

# You can also make your code fail to compile if you use deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0


SOURCES += \
        src/main.cpp \
        src/mainwindow.cpp \
    src/myonlinetimer.cpp \
    src/myofflinetimer.cpp \
    src/processa.cpp

HEADERS += \
        include/mainwindow.h \
    include/myonlinetimer.h \
    include/myofflinetimer.h \
    include/processa.h \
    include/definitions.h

FORMS += \
        ui/mainwindow.ui

################################################################################
# ICONS
iconos.path = $$PREFIX/share/$${TARGET}/icons
iconos.files += \
    share/$${TARGET}/icons/camera.ico \
    share/$${TARGET}/icons/document-open.png \
    share/$${TARGET}/icons/document-save-as.png \
    share/$${TARGET}/icons/help-about.png \
    share/$${TARGET}/icons/camera.png \
    share/$${TARGET}/icons/document-properties.png \
    share/$${TARGET}/icons/document-save.png \
    share/$${TARGET}/icons/help-contents.png

# DESKTOP
desktop.path = $$PREFIX/share/applications
desktop.files += share/applications/$${TARGET}.desktop


# DOCS
documentation.path   = $$PREFIX/share/doc/$${TARGET}
documentation.files += \
    share/doc/$${TARGET}/$${TARGET}-userguide.pdf


DISTFILES += share/*/*/* \
    snap/* \
    win/* \
    debian/* \
    extras/compilar-opencv.sh \
    clean_all.sh  \
    ChangeLog  \
    README.md \
    $${TARGET}.rc

################################################################################
## Intallation files

myapp.path   = $$PREFIX/bin
unix{
myapp.files += bin/$${TARGET}
}
win32{
myapp.files += bin/$${TARGET}.exe
}




INSTALLS    += myapp\
    documentation \
    iconos \
    desktop 


################################################################################

DEFINES += APP_VERSION=\\\"$$VERSION\\\"
DEFINES += APP_TARGET=\\\"$$TARGET\\\"

################################################################################


unix{
QMAKE_CLEAN += -r bin
}

APPARCHITECTURE = $$QMAKE_HOST.arch
equals(APPARCHITECTURE , "x86_64") {
    APPARCHITECTURE = "amd64"
}
equals(APPARCHITECTURE , "x86") {
    APPARCHITECTURE = "i386"
}
equals(APPARCHITECTURE , "i686") {
    APPARCHITECTURE = "i386"
}


message(" ")
message(" Program filename: $$TARGET")
message(" Program version: $$VERSION")
message(" Host architecture $$QMAKE_HOST.arch: $$APPARCHITECTURE")
message(" ")

APPSUMMARY="The speckleonline program is an image acquisition tool."
APPDESCRIPTION="The speckleonline program is an image acquisition tool to dynamic speckle phenomenon."


################################################################################
## Generating the dialogsobre.ui file
################################################################################
equals(QT_MAJOR_VERSION,4) {
    ABOUT_FILE_STRING=$$system('cat ui/dialogsobre.ui.input',blob)
}
else {
    ABOUT_FILE_STRING=$$cat(ui/dialogsobre.ui.input,blob)
}
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPBUILDTIME, $$_DATE_)
equals(QT_MAJOR_VERSION,4) {
   system('echo "$$ABOUT_FILE_STRING" > ui/dialogsobre.ui'):HAS_BIN=FALSE
}
else {
   write_file(ui/dialogsobre.ui, ABOUT_FILE_STRING)
}


################################################################################
## Generating the speckleonline.nsi file to create the *.exe file
################################################################################
equals(QT_MAJOR_VERSION,4) {
win32{
    NSI_FILE_STRING=$$system('type win\$${TARGET}.nsi.input',blob)
}
unix{
    NSI_FILE_STRING=$$system('cat win/$${TARGET}.nsi.input',blob)
}
}
else {
    NSI_FILE_STRING=$$cat(win/$${TARGET}.nsi.input,blob)
}
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
equals(QT_MAJOR_VERSION,4) {
   system('echo "$$NSI_FILE_STRING" > win/$${TARGET}.nsi'):HAS_BIN=FALSE
}
else {
   write_file(win/$${TARGET}.nsi, NSI_FILE_STRING)
}
QMAKE_CLEAN += win/$${TARGET}.nsi



################################################################################
## Generating the snapcraft.yaml file to create the *.snap file
################################################################################
equals(QT_MAJOR_VERSION,4) {
    SNAPCRAFT_YAML_FILE_STRING=$$system('cat snap/snapcraft.yaml.input',blob)
}
else {
    SNAPCRAFT_YAML_FILE_STRING=$$cat(snap/snapcraft.yaml.input,blob)
}
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
equals(QT_MAJOR_VERSION,4) {
   system('echo "$$SNAPCRAFT_YAML_FILE_STRING" > snap/snapcraft.yaml'):HAS_BIN=FALSE
}
else {
   write_file(snap/snapcraft.yaml, SNAPCRAFT_YAML_FILE_STRING)
}
QMAKE_CLEAN += snap/snapcraft.yaml


################################################################################
## Generating the control file to create the *.deb file
################################################################################
equals(QT_MAJOR_VERSION,4) {
    DEBIAN_CONTROL_FILE_STRING=$$system('cat debian/control.input',blob)
    APPDEPENDENCES='libopencv-contrib2.4v5 (>=2.4.9.1), libqtgui4 (>=4:4.8.7), libqtcore4 (>=4:4.8.7)'
}
else {
    DEBIAN_CONTROL_FILE_STRING=$$cat(debian/control.input,blob)
    APPDEPENDENCES='libopencv-contrib2.4v5 (>=2.4.9.1), libqt5gui5 (>=5.5.1), libqt5core5a (>=5.5.1), libqt5widgets5 (>=5.5.1)'
}
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPDEPENDENCES, $$APPDEPENDENCES)
equals(QT_MAJOR_VERSION,4) {
    system('echo "$$DEBIAN_CONTROL_FILE_STRING" > debian/control'):HAS_BIN=FALSE
}
else {
    write_file(debian/control, DEBIAN_CONTROL_FILE_STRING)
}
QMAKE_CLEAN += debian/control

