//This file comes from http://code.google.com/p/libjson-glibmm/
//and it is licensed under the GPLv2+.
//Copyright (C) 2009 tevaum
//Copyright (C) 2009 mxsoares
#include "JsonNodeMM.hpp"

#include "JsonObjectMM.hpp"
#include "JsonArrayMM.hpp"

JsonNodeMM::JsonNodeMM(JsonNode *node){
  this->node = node;
}

JsonNodeMM:: ~JsonNodeMM(){
}

void JsonNodeMM::set_string(std::string value){
  json_node_set_string(this->node, value.c_str());
}


JsonArrayMM *JsonNodeMM::get_array(){
  return new JsonArrayMM(json_node_get_array(this->node));
}

JsonObjectMM *JsonNodeMM::get_object(){
  return new JsonObjectMM(json_node_get_object(this->node));
}

bool JsonNodeMM::get_boolean(){
  return (bool) json_node_get_boolean(this->node);
}

double JsonNodeMM::get_double(){
  return (double) json_node_get_double(this->node);
}

long long JsonNodeMM::get_int(){
  return (long long) json_node_get_int(this->node);
}

std::string JsonNodeMM::get_string(){
  return std::string((char *) json_node_get_string(this->node));
}

std::string JsonNodeMM::type_name(){
  return std::string((char *) json_node_type_name(this->node));
}

