//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef CBC_OSD_CONNECTOR_H
#define CBC_OSD_CONNECTOR_H

#include <sigc++/sigc++.h>
#include <memory>
#include <gtkmm.h>
#include <libsoupmm/session.h>
#include <libsoupmm/message.h>

#define CBC_VIDEO_BASE "http://www.cbc.ca/video/"
#define CBC_VIDEO_URL CBC_VIDEO_BASE "#/News"

class CBCOSDConnector
{
 public:
    static CBCOSDConnector* create(bool news, bool sports);

    static int get_default_polling_period() {return 1000 * 180;}; //milliseconds

    void connect(); //go get our json id

    void notify(Glib::ustring show_name, Glib::ustring show_id, Glib::ustring url);

    void start_polling(int msecs);
    bool get_watch_sports () const {return d_watch_sports;};
    bool get_watch_news () const {return d_watch_news;};
    void set_watch_sports (bool s) {d_watch_sports = s;};
    void set_watch_news (bool s) {d_watch_news = s;};
    virtual ~CBCOSDConnector();
    void stop_polling();

    Glib::ustring get_id() const {return id;};
    Glib::ustring get_news_id() const {return news_id;};
    Glib::ustring get_sports_id() const {return sports_id;};
    //signals
    sigc::signal<void, bool> connect_succeeded;
    sigc::signal<void, const char *, int> news_polled;
    sigc::signal<void, const char *, int> sports_polled;

 protected:
    CBCOSDConnector(bool news, bool sports);
 private:
    Glib::RefPtr<Soup::Session> web;
    Glib::ustring id; //a top-level id we need to reference
    Glib::ustring news_id; //a category id we need to reference
    Glib::ustring sports_id; //a category id we need to reference
    bool d_watch_news;
    bool d_watch_sports;
    sigc::connection timer;

    //callbacks
    void on_get_id_attempted(Glib::RefPtr<Soup::Message> &msg);
    void on_get_news_id_attempted(Glib::RefPtr<Soup::Message> &msg);
    void on_get_sports_id_attempted(Glib::RefPtr<Soup::Message> &msg);
    void on_news_polled(Glib::RefPtr<Soup::Message> &msg);
    void on_sports_polled(Glib::RefPtr<Soup::Message> &msg);

    //helpers
    bool poll();
    void poll_news();
    void poll_sports();

};

#endif // CBC_OSD_CONNECTOR_H
