//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef CBC_OSD_CONNECTOR_H
#define CBC_OSD_CONNECTOR_H

#include <sigc++/sigc++.h>
#include <memory>
#include <gtkmm.h>
#include <curlpp/Easy.hpp>

#define CBC_VIDEO_BASE "http://www.cbc.ca/player/"
#define CBC_VIDEO_URL CBC_VIDEO_BASE "News/"

class CBCOSDConnector
{
 public:
    static CBCOSDConnector* create(bool news, bool sports);

    static int get_default_polling_period() {return 1000 * 180;}; //milliseconds

    void connect();

    void notify(Glib::ustring show_name, Glib::ustring show_description, Glib::ustring show_id, Glib::ustring url);

    bool start_polling(int msecs);
    bool get_watch_sports () const {return d_watch_sports;};
    bool get_watch_news () const {return d_watch_news;};
    void set_watch_sports (bool s) {d_watch_sports = s;};
    void set_watch_news (bool s) {d_watch_news = s;};
    virtual ~CBCOSDConnector();
    void stop_polling();

    //signals
    sigc::signal<void, bool> connect_succeeded;
    sigc::signal<void, const char *, int> news_polled;
    sigc::signal<void, const char *, int> sports_polled;

 protected:
    CBCOSDConnector(bool news, bool sports);
 private:
    bool d_watch_news;
    bool d_watch_sports;
    sigc::connection timer;

    //callbacks
    void on_news_polled(curlpp::Easy *easy, int response, const char *data, size_t len);
    void on_sports_polled(curlpp::Easy *easy, int response, const char *data, size_t len);

    //helpers
    bool poll(bool &failed);
    bool poll_news();
    bool poll_sports();

    typedef sigc::slot<void, curlpp::Easy *, int, const char *, size_t> Slot;
    bool get(Glib::ustring url, Slot slot);
};

#endif // CBC_OSD_CONNECTOR_H
