//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef CBC_SHOW_H 
#define CBC_SHOW_H
#include <gtkmm.h>
class CBCShow
{
    public:

        CBCShow(Glib::ustring id, Glib::ustring title, Glib::ustring desc, bool live);

        CBCShow(const CBCShow& t);

        Glib::ustring get_id() const { return d_id; }
        Glib::ustring get_title() const { return d_title; }
        Glib::ustring get_description() const { return d_desc; }
	//! Destructor.
        ~CBCShow();

        bool is_showing() const { return d_live; }
    protected:
    private:
        Glib::ustring d_id;
        Glib::ustring d_title;
        Glib::ustring d_desc;
        bool d_live;
};

#endif // CBC_SHOW_H
