//  Copyright (C) 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>

#include <sigc++/functors/mem_fun.h>
#include <gtkmm.h>
#include "cbcosd-window.h"
#include "timing.h"
#include "main.h"

CBCOSDWindow::CBCOSDWindow(Glib::ustring load_filename)
{
    Glib::RefPtr<Gtk::Builder> xml
	= Gtk::Builder::create_from_file(Main::get_data_path() +
                                         "/glade/cbc-osd-window.ui");

    xml->get_widget("window", window);
    window->signal_delete_event().connect
      (sigc::mem_fun(*this, &CBCOSDWindow::on_window_closed));

    xml->get_widget("image", image);
    xml->get_widget("label", label);
    xml->get_widget("switch", switch_button);
    switch_button->property_active().signal_changed().connect(sigc::mem_fun(*this, &CBCOSDWindow::on_button_clicked)); 

    update_label();
    update_image();
}

void CBCOSDWindow::update_image()
{
  image->set(Main::get_data_path() + "/data/cbc-osd.png");
}

void CBCOSDWindow::update_label()
{
  if (switch_button->get_active() == true)
    label->set_text("Turn off to stop monitoring.");
  else
    label->set_text("Turn on to begin monitoring for\nlive news and sporting events.");
}

CBCOSDWindow::~CBCOSDWindow()
{
  delete window;
}

bool CBCOSDWindow::on_delete_event(GdkEventAny *e)
{
  hide();
  return true;
}

bool CBCOSDWindow::on_window_closed(GdkEventAny*)
{
  return false;
}
      
void CBCOSDWindow::on_button_clicked()
{
  update_label();
  update_image();
  Timing::instance().register_timer
    (sigc::mem_fun(this, &CBCOSDWindow::doit), 200);

}

bool CBCOSDWindow::doit()
{
  if (switch_button->get_active() == true)
    {
      switch_button->set_sensitive(false);
      if (Main::instance().restart_polling() == false)
        switch_button->set_active(false);
      switch_button->set_sensitive(true);
    }
  else
    Main::instance().stop_polling();
  return Timing::STOP;
}
