
// Experiencing with C++ operator new/delete overload
// see eg:http://www.scs.stanford.edu/~dm/home/papers/c++-new.html
//
// Use alternate allocator
// http://eli.thegreenplace.net/2008/10/17/memmgr-a-fixed-pool-memory-allocator
//
// Last but not least
// Use STL Allocator for STL container:
// http://www.sgi.com/tech/stl/alloc.html
// http://www.codeguru.com/Cpp/Cpp/cpp_mfc/stl/article.php/c4079
// http://www.ddj.com/cpp/184403759
// ....

#include <memory>
#include <iostream>
#include "AllocateMe.hh"
#include "memmgr.h"
#include "MySTLAllocator.hh"


void FunAllocateMe() {

	  AllocateMe  O1(std::string("StaticO1"));

	  AllocateMe* PO2;
	  PO2 = new AllocateMe("DynamicO2");
	  AllocateMe  TO3[2];
	  AllocateMe*  PO4;
	  PO4 = new AllocateMe[3];

	  std::cout << "O1 = " << O1.getName() << std::endl;
	  std::cout << "O2 = " << PO2->getName() << std::endl;
	  std::cout << "TO3 = {"
		  << TO3[0].getName()
		  << ", "
		  << TO3[1].getName()
		  << "}" << std::endl;
	  std::cout << "PO4 = {"
	  	  << PO4[0].getName()
	  	  << ", "
	  	  << PO4[1].getName()
	  	  << ", "
	  	  << PO4[2].getName()
	  	  << "}" << std::endl;

	  delete PO2;
	  delete[] PO4;
} // end of AllocateMe

void FunAllocateMeOver() {
	  AllocateMeOver  O1(std::string("OverStaticO1"));
	  AllocateMeOver* PO2;
	  PO2 = new AllocateMeOver("OverDynamicO2");
	  AllocateMeOver  TO3[2];
	  AllocateMeOver*  PO4;
	  PO4 = new AllocateMeOver[3];

	  std::cout << "OverO1 = " << O1.getName() << std::endl;
	  std::cout << "OverO2 = " << PO2->getName() << std::endl;
	  std::cout << "OverTO3 = {"
		  << TO3[0].getName()
		  << ", "
		  << TO3[1].getName()
		  << "}" << std::endl;
	  std::cout << "OverPO4 = {"
	  	  << PO4[0].getName()
	  	  << ", "
	  	  << PO4[1].getName()
	  	  << ", "
	  	  << PO4[2].getName()
	  	  << "}" << std::endl;

	  delete PO2;
	  delete[] PO4;
} // end of AllocateMeOverOver()

int
main(int argc, char* argv[]) {

  memmgr_init();

  FunAllocateMe();
  FunAllocateMeOver();

  return 0;  
}
