load x.asc
load y.asc
load z.asc

Nx = length(x);
Ny = length(y);
Nz = length(z);

nx2 = 1:2:Nx;
ny2 = 1:3:Ny;
nz2 = 1:2:Nz;

x2 = x(nx2);
y2 = y(ny2);
z2 = z(nz2);

% plot(w,v) in (z,y) plane
subplot(211);
load wsec.asc; load vsec.asc; 

%quiver(z,y,wsec,vsec)
%quiver(z,y2,wsec(ny2,:),vsec(ny2,:))
%quiver(z2,y2,2*wsec(ny2,nz2),2*vsec(ny2,nz2));

% perdiodic-shift (w,v) 
[Ny,Nz] = size(wsec);
wshift = zeros(Ny,Nz);
vshift = zeros(Ny,Nz);
shift = 6; % chosen because it looks good for a part. data set
for nz=1:Nz
  vshift(:,nz) = vsec(:,mod(nz+shift,Nz)+1);
  wshift(:,nz) = wsec(:,mod(nz+shift,Nz)+1);
end
%quiver(z,y,wshift,vshift)
quiver(z,y2,wshift(ny2,:),vshift(ny2,:))
%quiver(z2,y2,wshift(ny2,nz2),vshift(ny2,nz2));
  
axis([min(z) max(z) min(y) max(y)]);
xlbl('z')
ylbl('y')
%load wsec.asc; load vsec.asc; 

% plot (u,v) in (x,y) plane
subplot(212)
load uside.asc; load vside.asc; 

% Add base flow onto u
[Ny,Nx] = size(uside);
for nx = 1:Nx
  uside(:,nx) = uside(:,nx) + y;
end

%quiver(x,y,uside,vside);
quiver(x,y2,uside(ny2,:),vside(ny2,:));


%quiver(x2,y2,uside(ny2,nx2),vside(ny2,nx2));
axis([min(x) max(x) min(y) max(y)]);
xlbl('x')
ylbl('y')

% 16 64 256 1024



