/* orrsommfunc.h: calculates Orr-Sommerfeld eigenfunctions of Poisseuille flow
 * Channelflow-0.9
 *
 * Copyright (C) 2001  John F. Gibson  
 *  
 * jgibson@mail.sjcsf.edu  
 * John F. Gibson 
 * St. John's College
 * 1160 Camino de la Cruz Blanca
 * Santa Fe, NM 87501
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, U
 */

#ifndef ORRSOMMFUNC_H
#define ORRSOMMFUNC_H

#include "mathdefs.h"
#include "chebyshev.h"
#include "basisfunc.h"

class OrrSommFunc : public BasisFunc {
public:
  OrrSommFunc(Real Reynolds, int Ny, int kx, int kz, 
	      Real Lx, Real Lz, Real a, Real b, bool manual=false);
  OrrSommFunc(const string& filebase);
  OrrSommFunc& operator=(const OrrSommFunc& os);

  bool operator==(const OrrSommFunc& os) const;
  bool operator!=(const OrrSommFunc& os) const;
  
  Real reynolds() const;
  Complex eigenvalue() const;
  Complex omega() const;
  Complex lambda() const;

  const ComplexChebyCoeff& pressure() const;
  const ComplexChebyCoeff& p() const;
  ComplexChebyCoeff totalPressure() const;

  void chebyfft(const ChebyTransform& t);
  void ichebyfft(const ChebyTransform& t);
  void makeSpectral(const ChebyTransform& t);
  void makePhysical(const ChebyTransform& t);
  
  OrrSommFunc& operator *= (Real c);
  OrrSommFunc& operator *= (Complex c); 

  void save(const string& filebase);
  void bfsave(const string& filebase);
  
protected:
  Real reynolds_;
  Complex omega_;
  ComplexChebyCoeff pressure_; // pressure profile

  inline int chebc(int n) {return (n<0) ? 0 : ((n==0) ? 2 : 1);}
  inline int chebd(int n) {return (n<0) ? 0 : 1;}

  void solve_for_v_omega(bool manual);
  void solve_for_p();
  void solve_for_u();
  void solve_for_w();
};

inline int chebc(int n) {return (n<0) ? 0 : ((n==0) ? 2 : 1);}
inline int chebd(int n) {return (n<0) ? 0 : 1;}
   
    

  
  

#endif
