/* complexdefs.h: some small mathematical conveniences for complex numbers
 * Channelflow-0.9
 *
 * Copyright (C) 2004  John F. Gibson  
 *  
 * jgibson@mail.sjcsf.edu  
 * John F. Gibson 
 * St. John's College
 * 1160 Camino de la Cruz Blanca
 * Santa Fe, NM 87501
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, U
 */

#ifndef COMPLEXDEFS_H
#define COMPLEXDEFS_H

#include "mathdefs.h"

// These functions are isolated in their own header file so they can be 
// easily excluded, to avoid name clashes when working with other libraries
// (like Octave).

inline Real norm (const Complex& z) {
  return pythag (Re (z), Im (z));
}
inline Real phase (const Complex& z) {
  return atan2 (Im (z), Re (z));
}
inline Complex exp (const Complex& z) {
  return exp (Re (z)) * (cos (Im (z)) + I * sin (Im (z)));
}
inline Complex log (const Complex& z) {
  return log (norm (z)) + I * phase (z);
}

#endif
