function yzframe(u_yz, v_yz, w_yz, umag, y,z)

  ulim = [-umag:umag/10:umag];
  [C,h] = contourf(z, y, u_yz, ulim); 
  set(h, 'LineStyle', 'none');
  hold on;
  %axis equal
  %axis tight
  %contourf(z, y, u_yz, ulim, 'g:'); 
  caxis([-umag umag]);
  axis([min(z) max(z) min(y) max(y)]);

  ny2 = 1:2:length(y);
  nz2 = 1:2:length(z);
  y2=y(ny2);
  z2=z(nz2);
  
  quiver(z2,y2, w_yz(ny2,nz2), v_yz(ny2,nz2), 'k'); 
  %plot([min(z) max(z)], [-0.7 -0.7], 'k-');
  hold off;
  minz = fixdigits(min(z), 3);
  maxz = fixdigits(max(z), 3);
  miny = fixdigits(min(y), 3);
  maxy = fixdigits(max(y), 3);
  
  xlabel('z');
  ylabel('y');
  set(gca, 'XTick', [minz maxz]);
  set(gca, 'YTick', [miny maxy]);
