/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RM_H
#define RM_H
#include "common.h"
#include <qstringlist.h>


/**
The Recipe Manager (RM) static class is used for various operation
on the recipe such as the search of cocktail using a dico, obtaining a list of
names...

@author Bertrand Haut
*/
class RM{
public:
    RM();

    ~RM();

	//! return the recipes containing the liquidElement's specified
	
	/**
	return the recipes containing the liquidElement specified in the QStringList names
	using the dicoRecipe dico
		all = true -> all the liquidElement must be in the recipes
		all = false -> only one of the liquidElement mut be in the recipes
	*/
	static QStringList getRecipeContaining(dicoRecipe dico, QStringList names, bool all);

	//! return the recipes containing the liquidElement's specified wihtout 
	
	/**
	return the recipes containing the liquidElement specified in the QStringList names
	using the dicoRecipe dico and none of the liquidElement specified in namesWithout
		all = true -> all the liquidElement must be in the recipes
		all = false -> only one of the liquidElement mut be in the recipes
	*/

	static QStringList getRecipeContaining(dicoRecipe dico, QStringList names, QStringList namesWithout,bool all);
	
	/**
	convert a setRecipe into a QStringList of their name
	*/
	static QStringList toStringList(setRecipe recipes);

	/**
	return the list of the entries of a dicoRecipe
	*/
	static QStringList getListOfElementsName(QMap<QString, setRecipe > * dicoFind);

private:
	static setRecipe getSetOfRecipeContaining(dicoRecipe dico, QStringList names, bool all);
};

#endif
