/*
**  FontAttributesManager.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditor_H_FontAttributesManager
#define _CodeEditor_H_FontAttributesManager

#include <Foundation/NSObject.h>
#include <AppKit/NSFontManager.h>

@class NSPanel;
@class NSButton;
@class NSPopUpButton;
@class NSColorWell;
@class NSMutableDictionary;
@class NSFontManager;
@class RulesetManager;

@interface FontAttributesManager : NSObject
{
  /* FontAttributesPanel */
  NSPanel *fontAttributesPanel;
  NSColorWell *normalColor, *commentColor, *stringColor;
  NSColorWell *preprocessorColor, *keywordColor, *typeColor;
  NSButton *normalFont, *commentFont, *stringFont;
  NSButton *preprocessorFont, *keywordFont, *typeFont;
  NSPopUpButton *commentTraitButton, *stringTraitButton;
  NSPopUpButton *preprocessorTraitButton, *keywordTraitButton;
  NSPopUpButton *typeTraitButton;
  NSFontTraitMask commentMask, stringMask, preprocessorMask;
  NSFontTraitMask keywordMask, typeMask; 

  RulesetManager *rulesetManager;
  NSMutableDictionary *colorCache, *fontCache;
  NSString *selectedFont;
  NSFontManager *fontManager;
}

+ (FontAttributesManager *) sharedFontAttributesManager;

- (NSPanel *) fontAttributesPanel;
- (void) orderFrontFontAttributesPanel: (id) sender;

/* Font Attributes Panel */
- (void) colorAction: (id) sender;
- (void) fontAction: (id) sender;
- (void) traitAction: (id) sender;
- (void) revertToSavedFontAttributes: (id) sender;

/* FontPanel */
- (void) changeFont: (id) sender;

@end

#endif /* _CodeEditor_H_FontAttributesManager */
