/*
**  MethodViewer.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "MethodViewer.h"
#include "Utilities.h"
#include <AppKit/AppKit.h>
#include <CodeEditorView/CodeEditorView.h>
#include <CodeEditorView/CEView+Methods.h>
#include <CodeEditorView/MethodNode.h>

static MethodViewer *sharedViewer;

@implementation MethodViewer

+ (MethodViewer *) sharedMethodViewer
{
  if (!sharedViewer)
    {
      sharedViewer = [[MethodViewer alloc] init];
    }
  return sharedViewer;
}

- (void) outlineViewSelectionDidChange: (NSNotification *) not
{
  int index = [outlineView selectedRow];
  unsigned position = [[outlineView itemAtRow: index] position];
  [currentCEView setSelectedRange: NSMakeRange(position, 0)];
  [currentCEView scrollSelectedRangeToTop: self];
}

- (id) outlineView: (NSOutlineView *) outlineView
             child: (int) index
            ofItem: (id) item
{
  if (item == nil)
    return [[rootNode children] objectAtIndex: index];

  if ([[item children] count])
    return [[item children] objectAtIndex: index];
  else
    return nil;
}

- (BOOL) outlineView: (NSOutlineView *) outlineView
         isItemExpandable: (id) item
{
  if (item == nil)
    return YES;

  if ([[item children] count])
    return YES;
  else
    return NO;
}

- (int) outlineView: (NSOutlineView *) outlineView
        numberOfChildrenOfItem: (id) item
{
  if (item == nil)
    return [[rootNode children] count];

  return [[item children] count];
}

- (id) outlineView: (NSOutlineView *) outlineView
       objectValueForTableColumn: (NSTableColumn *) tableColumn
       byItem: (id) item
{
  return [(MethodNode *)item name];
}

- (void) windowDidBecomeKey: (NSNotification *) not
{
  [self setCodeEditorView: currentCEView];
}

- (void) setCodeEditorView: (CodeEditorView *) ceView
{
  ASSIGN(currentCEView, ceView);

  if (currentCEView == nil)
    return;
  
  ASSIGN(rootNode, [currentCEView methodRoot]);

  [outlineView reloadData];
}

- (NSPanel *) methodPanel
{
  if (methodPanel == nil)
    {
      if(NO == [NSBundle loadNibNamed: @"MethodPanel.gorm" owner: self])
        {
           NSBeep();
           return nil;
        }
    }
  [outlineView setAutoresizesAllColumnsToFit: YES];
  [outlineView setAllowsColumnSelection: NO];
  [outlineView setAllowsColumnReordering: NO];

  return methodPanel;
}

- (void) orderFrontMethodPanel: (id) sender
{
  if ([self methodPanel] == nil)
    {
       NSBeep();
       return;
    }
  [methodPanel makeKeyAndOrderFront: self];
}

- (void) dealloc
{
  RELEASE(currentCEView);
  RELEASE(rootNode);
  [super dealloc];
}

@end
