/*
**  CEView+TextUtils.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**          Bjoern Giesler <bjoern@giesler.de>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditorBundle_H_CEView_TextUtils
#define _CodeEditorBundle_H_CEView_TextUtils

#include "CodeEditorView.h"

@interface CodeEditorView (TextUtils)

// These two return the word/line at the given position, as well as
// the spanning range. If you pass nil as aWord/aLine, they don't
// perform substringing, making them a bit faster.
// atPos:returnWord:returnRange: works according to the
// isalnum()/isspace() functions in ctype.h. That means that you can't
// find words like "@implementation". You *can*, however, find "@" and
// "implementation" right next to each other. Currently, we don't do
// that. Sorry.

/* Primitive
 * It will trim the searchRange by default
 * So don't worry about out of range
 */
- (NSString *) wordAtPosition: (int) position
                      inRange: (NSRange *) range
                  searchRange: (NSRange) searchRange;
- (NSString *) lineAtPosition: (int) position
                      inRange: (NSRange *) range
                  searchRange: (NSRange) searchRange;

/* Search for any non-space word or character. Autoreleased.
 * If not found, return nil, range.location == NSNotFound
 */
- (NSString *) wordAtPosition: (int) position
                      inRange: (NSRange *) range;
- (NSString *) lineAtPosition: (int) position
                      inRange: (NSRange *) range;

// The following methods are just convenience wrappers for the
// former.

- (NSRange) rangeOfWordAtPosition: (int) position;
- (NSRange) rangeOfWordAtCursor;
- (NSString *) wordAtPosition: (int) position;
- (NSString *) wordAtCursor;

- (NSRange) rangeOfLineAtPosition: (int) position;
- (NSRange) rangeOfLineAtCursor;
- (NSString *) lineAtPosition: (int) position;
- (NSString *) lineAtCursor;

/* Return the line number at position */
- (unsigned) lineNumberAtPosition: (int) position;

@end

#endif /* _CodeEditorBundle_H_CEView_TextUtils */
