/*
**  CodeEdivorViewPreference.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**          Bjoern Giesler <bjoern@giesler.de>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "CodeEditorViewPreference.h"
#include <AppKit/AppKit.h>

static CodeEditorViewPreference *sharedPreference;

@implementation CodeEditorViewPreference

+ (CodeEditorViewPreference *) sharedCodeEditorViewPreference
{
  if (sharedPreference == nil)
    {
      sharedPreference = [[CodeEditorViewPreference alloc] init];
      [sharedPreference setTab: @"Tab"];
      [sharedPreference setAutoFontification: NO];
      [sharedPreference setAutoFontificationThreshold: NO];
      [sharedPreference setAutoFontificationEachLine: NO];
      [sharedPreference setAutoIndentation: NO];
      [sharedPreference setAutoMarkBlock: NO];
      [sharedPreference setAutoIndentation: NO];
      [sharedPreference setFontificationInterval: 10];
      [sharedPreference setFontificationThreshold: 10];
      [sharedPreference setAutoMarkThreshold: NO];
      [sharedPreference setMarkThreshold: 5000];
      [sharedPreference setDisplaySideView: NO];
    }

  return sharedPreference;
}

- (void) setDisplaySideView: (BOOL) bool
{
  displaySideView = bool;
}

- (BOOL) displaySideView
{
  return displaySideView;
}

// Tab action
- (void)setTab: (NSString *)string
{
  if (string)
    {
      ASSIGN(tab, string);

      if ([string isEqualToString: @"Tab"])
        ASSIGN(tabString, @"\t");
      else if ([string isEqualToString: @"Auto"])
        ASSIGN(tabString, nil);
      else 
        {
           ASSIGN(tabString, [@"                                        " 
                             substringToIndex: [string intValue]]);

          /* Default is 2 spaces */
          if ([tabString isEqualToString: @""])
            ASSIGN(tabString, @"  ");
        }
    }
  else
    {
      ASSIGN(tab, @"Tab");
      ASSIGN(tabString, @"\t");
    }
}

- (NSString *)tab
{
  return tab;
}

- (NSString *) tabString
{
  return tabString;
}

- (void) dealloc
{
  RELEASE(tab);
  RELEASE(tabString);
  [super dealloc];
}

- (void) setAutoFontification: (BOOL) bool
{
  autoFontification = bool;
}

- (BOOL) autoFontification
{
  return autoFontification;
}

- (void) setFontificationInterval: (float)interval
{
  fontifyInterval = interval;
}

- (float)fontificationInterval
{
  return fontifyInterval;
}

- (void) setAutoFontificationThreshold: (BOOL) bool
{
  autoFontificationThreshold = bool;
}

- (BOOL) autoFontificationThreshold
{
  return autoFontificationThreshold;
}

- (void) setFontificationThreshold: (unsigned)threshold
{
  fontifyThreshold = threshold;
}

- (unsigned)fontificationThreshold
{
  return fontifyThreshold;
}

- (void) setAutoFontificationEachLine: (BOOL) bool
{
  autoFontificationEachLine = bool;
}

- (BOOL) autoFontificationEachLine
{
  return autoFontificationEachLine;
}

- (void)setAutoIndentation: (BOOL) bool
{
  autoIndentation = bool;
}

- (BOOL) autoIndentation
{
  return autoIndentation;
}

- (void) setAutoMarkBlock: (BOOL) bool
{
  autoMarkBlock = bool;
}

- (BOOL) autoMarkBlock
{
  return autoMarkBlock;
}

- (void) setAutoMarkThreshold: (BOOL) bool
{
  autoMarkThreshold = bool;
}

- (BOOL) autoMarkThreshold
{
  return autoMarkThreshold;
}

- (void) setMarkThreshold: (unsigned) threshold
{
  markThreshold = threshold;
}

- (unsigned) markThreshold
{
  return markThreshold;
}


@end
