<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");
?>

<?php
// Shows page header
$theme["page-title"] = _("About");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
  <table border="0" cellpadding="0">
  <tr>
    <td valign="top"><img src="<?php echo $theme["image_dir"];?>dadrill.png" alt="daDrill"/></td>
    <td valign="top">
    <h1><?php echo _("daDrill");?></h1>
    <p>
    <?php echo _("Version");?> <?php echo $config["version"];?><br/>
    <?php echo _("Last modified");?> <?php echo $config["last-modified"];?>
    </p>
    <p><?php echo _("daDrill is an interactive PHP/MySQL application that allows you to store, query and navigate through a collection of references indexed according to the BibTeX standard.  You may view it as your \"personal DBLP\" or your \"free and better EndNote\".");?></p>
    <p><?php echo _("Programmed by");?> 
    <a href="http://www.leduotang.com/sylvain/">Sylvain Hall&eacute;</a>.
    </p>
    <p>
    <?php echo _("Markdown rendering functionality programmed by");?>
    <a href="http://www.michelf.com/">Michel Fortin</a>.
    </p>
<?php
// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication;");
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}
?>
    <p><?php echo _("Currently indexing");?> <?php echo db_num_rows($result); ?>
    <?php echo _("paper(s) and");?>
<?php
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."author;");
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}
?>
    <?php echo db_num_rows($result); ?> <?php echo _("author(s) on");?> 
    <?php echo $config["ddDBHost"]; ?>.
<?php
$result = db_query($db, "SELECT SUM(LENGTH(fullpapertext)) as thesize FROM ".$config["ddDBPrefix"]."publication;");
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}
$row = db_fetch_assoc_array($result);

echo number_format($row["thesize"] / 1024);
echo _("kb of full (plain) text indexed in ");

$result = db_query($db, "SELECT COUNT(*) as thenumber FROM ".$config["ddDBPrefix"]."publication WHERE LENGTH(fullpapertext) > 0;");
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}
$row = db_fetch_assoc_array($result);
echo $row["thenumber"]; ?> <?php echo _("paper(s)");?>.</p>

<p><?php

$result = db_query($db, "SELECT COUNT(*) AS thenumber FROM ".$config["ddDBPrefix"]."publication WHERE hasSummary IS NOT NULL;");
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}
$row = db_fetch_assoc_array($result);

echo $row["thenumber"]._(" paper(s) have a reading summary.")."</p>\n\n";
?>
    <p><?php echo _("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.");?></p>

    <p><?php echo _("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.");?></p>

    <p><?php echo _("You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA");?></p>
    
    </td>
  </tr>
  </table>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2008-03-09";
show_theme_part("page-lower-body");
?>
