<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

$author_name = "CONCAT_WS(' ', IF(".$config["ddDBPrefix"]."author.firstName <> '', ".$config["ddDBPrefix"]."author.firstName, NULL), IF(".$config["ddDBPrefix"]."author.vonPart <> '', ".$config["ddDBPrefix"]."author.vonPart, NULL), IF(".$config["ddDBPrefix"]."author.lastName <> '', ".$config["ddDBPrefix"]."author.lastName, NULL), IF(".$config["ddDBPrefix"]."author.jrPart <> '', ".$config["ddDBPrefix"]."author.jrPart, NULL))";
$query_string = "SELECT $author_name as authorname, ".$config["ddDBPrefix"]."author.authorKey as akey, COUNT(*) as number FROM ".$config["ddDBPrefix"]."author, ".$config["ddDBPrefix"]."publication WHERE ".$config["ddDBPrefix"]."publication.bibtexAuthor LIKE CONCAT('%', $author_name, '%') GROUP BY authorname ORDER BY ".$config["ddDBPrefix"]."author.lastName;";
$result = db_query($db, $query_string);
if (!$result)
{
  echo (_("No result; maybe an error, see below if MySQL says something."));
  echo db_error($db);
  
}

// Counts columns
if (isset($_GET["columns"]))
  $num_columns = $_GET["columns"];
else
  $num_columns = $config["ddAuthorCols"];

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Browse authors");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Browse authors");?></h1>
<p><?php echo db_num_rows($result); ?> <?php echo _("matching author(s).");?>
<?php echo _("Between parentheses is the number of papers that this author has in the database.");?></p>

<form name="authors" method="post" action="graph-collaborations">

<table border="0" cellpadding="10">
<tr><td valign="top">
<ul class="authorbullet">
<?php
$entry = 1;
$step = ceil(db_num_rows($result) / $num_columns);
$next_change = $step;
while ($row = db_fetch_assoc_array($result))
{
  echo "<li><input type=\"checkbox\" name=\"seed-author-".$row["akey"]."\"/>\n<a href=\"".author_url($row["akey"])."\">";
  echo $row["authorname"];
  //echo $row["vonPart"]." ".$row["lastName"].", ".$row["firstName"]." ".$row["jrPart"];
  echo "</a>\n";
  echo "<span class=\"greyed-out\">(".$row["number"].")</span></li>\n";
  $entry++;
  if ($entry > $next_change)
  {
    // Time to change column
    echo "</ul>\n";
    echo "</td>\n<td valign=\"top\">\n";
    echo "<ul class=\"authorbullet\">\n";
    $next_change += $step;
  }
}
?>
</ul></td></tr>
</table>

<p><a href="browse-authors?columns=<?php echo ($num_columns - 1); ?>"><?php echo ($num_columns - 1); ?>-column view</a>&nbsp;<a href="browse-authors?columns=<?php echo ($num_columns + 1); ?>"><?php echo ($num_columns + 1); ?>-column view</a></p>

<p><?php echo _("You can select a number of authors and display the collaboration graph for them.");?></p>

<input type="submit" value="<?php echo _("Show the graph");?>"/>
<input type="reset" value="<?php echo _("Reset");?>"/>

<input type="hidden" name="num-authors" value="<?php echo db_num_rows($result);?>"/>

</form>

<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>

<?php
// Closes connection
db_close($db);
?>
