<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["paperKey"])
{
  die("No paper key passed to the page.");
}
else
{
  // Normalized identifer
  $numeric_key = $_GET["paperKey"];
}

// Shows page header
$theme["page-title"] = _("Add comment");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>

<h1><?php echo _("Add a comment");?></h1>

<form name="comment-add" method="post" action="<?php echo menu_url("comment-added");?>">

<input type="hidden" name="paperKey" value="<?php echo $numeric_key;?>"/>

<?php
if ($_SESSION["username"] !== null)
{
  echo "<input type=\"hidden\" name=\"commentAuthor\" value=\"'".$_SESSION["username"]."'\"/>\n";
}
else
{
  echo "<input type=\"hidden\" name=\"commentAuthor\" value=\"null\"/>\n";
}
?>

<table>

<tr>
<td><?php echo _("Comment type");?>:</td>
<td>
<select name="commentType">
  <option value="other"><?php echo _("General comment");?></option>
  <option value="summary"><?php echo _("Paper summary");?></option>
</select>
</td>
</tr>

<tr>
<td><?php echo _("Date and time");?>:</td>
<td>
<input type="text" name="date-time" value="<?php echo date("Y-m-d H:i:s");?>"/>
</td>
</tr>

<tr>
<td colspan="2">
<textarea name="commentText" rows="20" cols="80">
</textarea>
</td>
</tr>

<tr>
<td colspan="2">
<input type="submit" value="<?php echo _("Submit");?>"/>
</td>
</tr>

</table>

</form>

<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2008-01-06";
show_theme_part("page-lower-body");
// :folding=explicit:
?>
