<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Theme values
$theme["modif-date"] = "2008-03-18";
$theme["page-title"] = _("Comment added");

// Fetches records from the database
$query_string = "UPDATE ".$config["ddDBPrefix"]."comment SET commentDate = '".$_POST["date-time"]."', commentText = '".db_encode($_POST["commentText"])."', commentType = '".$_POST["commentType"]."' WHERE commentKey = ".$_POST["commentKey"]." LIMIT 1;";
$result = db_query($db, $query_string);
if (!$result)
{
  show_theme_part("page-header");
  show_theme_part("page-upper-body");
  echo "<h1>"._("Error editing comment")."</h1>\n\n";
  echo "<p>"._("See below if MySQL says something.")."</p>\n";
  echo db_error($db);
  close_page();
}

// If the comment is a summary, marks the paper has having a summary
if ($_POST["commentType"] === "summary")
{
  $query_string = "UPDATE ".$config["ddDBPrefix"]."publication SET hasSummary = ".$_POST["commentKey"]." WHERE `key` = ".$_POST["paperKey"]." LIMIT 1;";
  $result = db_query($db, $query_string);
  if (!$result)
  {
    show_theme_part("page-header");
    show_theme_part("page-upper-body");
    echo "<p>"._("No result; maybe key does not exist?  See below if MySQL says something.")."</p>\n";
    echo db_error($db);
    close_page();
  }
}

// Redirects immediately to paper page (with anchor)
header("Location: ".paper_url($_POST["paperKey"])."#comment-".$_POST["commentKey"]);

// :folding=explicit:
?>
