<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die(_("No paper key passed to the page."));
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."conference WHERE TRIM(bibtexBooktitle) = ".urldecode($_GET["key"]).";");

// Gets the row
if ($result)
  $row = db_fetch_assoc_array($result);
else
  $row = array();

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Conference details");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Conference details");?></h1>

<p><?php echo _("This page is populated by collating paper entries with the same book title. Additional information (CFP, dates, etc.) can be entered.");?></p>

<table border="0" cellpadding="0" cellspacing="5" style="margin-bottom:10px;">
<tr>
<td valign="middle">
<a class="transparentimage" href="conference-edit?key=<?php echo urlencode($_GET["key"]); ?>"><img border="0" src="images/icon-pencil.png" alt="Edit"/></a>
</td>
<td valign="middle">
<a class="submenubar" href="conference-edit?key=<?php echo urlencode($_GET["key"]); ?>">Edit</a>&nbsp;&nbsp;&nbsp;
</td>
<?php
// Url to full ASCII CFP if any
if ($row["cfpPlainText"] != "")
{
  echo "<td valign=\"middle\"><a class=\"transparentimage\" href=\"conference-full-text?key=".$_GET["key"]."".((isset($_GET["full-text-query"]) && $_GET["full-text-query"] != "") ? "&amp;full-text-query=".urlencode($_GET["full-text-query"]) : "")."\"><img border=\"0\" src=\"images/icon-text.png\" alt=\"CFP full text\"/></a></td>\n";
  echo "<td><a class=\"submenubar\" href=\"conference-full-text?key=".$_GET["key"]."\">View CFP (plain text)</a> (".number_format(strlen($row["cfpPlainText"]) / 1024, 0)." kb)&nbsp;&nbsp;&nbsp;</td>\n";
}
?>
</tr>
</table>

<table class="details" cellpadding="5" cellspacing="0">
<?php
$count = 0;
$modulo = 2;
$out = "";
if ($row["dateSubmission"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\""._("Approximate deadline for submission.")."\">"._("Submission")."</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["dateSubmission"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["dateNotification"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\""._("Approximate date for notification.")."\">"._("Notification")."</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["dateNotification"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["dateEvent"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\""._("Approximate date for the event.")."\">"._("Event")."</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["dateEvent"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
echo $out;
?>
</table>

<h2><?php echo _("Related Papers");?></h2>

<?php
// Checks if paper is cross-referenced by other papers, and gives the list
$result = db_query($db, "SELECT p1.bibtexTitle as p1bibtexTitle,p2.bibtexTitle as p2bibtexTitle,p2.bibtexCrossref as p2bibtexCrossref, p1.key as p1key, p2.key as p2key FROM ".$config["ddDBPrefix"]."publication as p1, ".$config["ddDBPrefix"]."publication as p2 where ((p1.identifierBibtex = p2.bibtexCrossref AND p2.bibtexCrossref IS NOT NULL) OR (p1.identifierBibtex = p2.identifierBibtex AND p2.bibtexCrossref IS NULL)) and TRIM(p1.bibtexBooktitle) = '".urldecode($_GET["key"])."' and p2.bibtexBooktitle = '".urldecode($_GET["key"])."' ORDER BY p1.bibtexYear,p1.identifierBibtex,p2.bibtexCrossref");
if (!$result)
{
  echo db_error($db);
}
echo "<ul class=\"paperbullet\">\n";
$gotta_close_main = false;
$gotta_close_sub = false;
while ($row = db_fetch_assoc_array($result))
{
  if ($row["p2bibtexCrossref"] == "") // New main entry
  {
    if ($gotta_close_sub)
    {
      echo "</ul>\n";
      $gotta_close_sub = false;
    }
    if ($gotta_close_main)
      echo "</li>\n";
    echo "<li class=\"paperbullet\"><a href=\"".paper_url($row["p2key"])."\">".$row["p1bibtexTitle"]."</a>";
    $gotta_close_main = true;
  }
  else // New sub entry
  {
    if (!$gotta_close_sub)
    {
      echo "\n<ul>\n";
    }
    echo "<li><a href=\"".paper_url($row["p2key"])."\">".$row["p2bibtexTitle"]."</a></li>\n";
    $gotta_close_sub = true;
  }
}
if ($gotta_close_sub)
  echo "</ul>\n";
if ($gotta_close_main)
  echo "</li>\n";
echo "</ul>\n";
/*
if (db_num_rows($result) > 0)
{
  echo "<h2>Cross-references</h2>\n";
  echo "<p>This paper is the BibTeX cross-reference for the following ".db_num_rows($result)." entrie(s).  This probably means the paper is a conference proceedings, or a book containing chapters.</p>\n";
  echo "<ul class=\"paperbullet\">\n";
  while ($row2 = db_fetch_assoc_array($result))
  {
    if ($row2["localUrlpdf"] || $row2["localUrlps"])
      echo "<li class=\"paperbullet\">\n";
    else
      echo "<li class=\"paperbullethollow\">\n";
    echo format_paper_entry($db, $row2, PRESENTATION_REGULAR)."\n</li>\n";
  }
  echo "</ul>\n";
}
*/
?>
<?php
// Plain-text comments if any
if ($row["notes"] != "")
{
  echo "<h2>"._("Comments")."</h2>\n";
  echo Markdown(urldecode($row["comments"]));
}
?>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
