<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

/* These are default installation settings.  DO NOT EDIT!  If you want
   customized settings, please edit the file named "my-config.conf".
   http://www.codewalkers.com/c/a/Miscellaneous/Configuration-File-Processing-with-PHP/1/
*/

/**
 * Basic information
 */
$config["version"]        = "0.7";          // Current version of the software
$config["last-modified"]  = "2008-03-09";  // Date of last modification

/**
 * I18N support information
 */
$config["language"]     = "en";             // Type the language code
$config["site-charset"] = "iso-8859-1";         // Site (target) character set
$config["lc-charset"]   = "iso-8859-1";         // Local (source) character set

/**
 * MySQL server configuration
 */
$config["ddDBHost"]     = "localhost";  // Host name or IP address for MySQL
                                        // server
$config["ddDBUser"]     = "root";       // User name in the server
$config["ddDBPassword"] = "";           // User password
$config["ddDBName"]     = "literature"; // Database name (default: "literature")
$config["ddDBPrefix"]   = "dadrill_";   // Prefix for all table names in DB
$config["ddDBMode"]     = "mysqli";     // Database connection mode ("mysql" or
                                        // "mysqli" (PHP >5)

/**
 * Web server configuration
 */
$config["has_htaccess"] = false;
$config["has_mod_rewrite"] = true;

/**
 * Themes for basic structure of pages
 */
$config["ddHost"]         = "localhost";  // Host name
$config["ddBaseDir"]      = "/dadrill/";  // Absolute dir
$config["ddThemeDir"]     = "themes/";  // Default directory for themes (with trailing slash)
$config["ddCurrentTheme"] = "classic";  // Classic theme

/**
 * Login
 */
$config["mustLogin"]    = false;         // Determines whether the user must
                                        // provide some sort of login to access the system

/**
 * Other constants
 */
$config["ddAuthorCols"]     = 3;    // Default number of columns for author view
$config["min-paper-length"] = 100;  // Full paper field must be at least 100 bytes
                                    // long to be displayed as "text"
$config["subcategoryChar"]  = "/";  // Subcategory delimiter
$config["pub-dir"] = "pub/";        // Default directory for local PS/PDF files
$config["limitResultsFullText"] = 20; // Number of results from full text query

/**
 * Formatting of entries
 */
$config["maxAuthorsEtAl"] = 2;      // After this number of authors, abridged
                                    // entries show "et al."
$config["excludeProceedings"] = true; // Do not show proceedings in paper lists (only papers IN proceedings)
?>
