<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Checks if a query string has been entered
$basic_text = "";
if (isset($_POST["full-text"]) && $_POST["full-text"])
{
  $basic_text = $_POST["full-text"];
}
if (isset($_GET["full-text"]) && $_GET["full-text"])
{
  $basic_text = urldecode($_GET["full-text"]);
}
if ($basic_text == "")
  die("No query passed.");

// Fetches records from the database
if ($_POST["field"] == "fulltext")
{
  $p = $config["ddDBPrefix"];
  $match_string = "(MATCH fullpapertext AGAINST ('".$basic_text."'))";
  $query_string = "SELECT ".
  $p."publication.`key` as `key`, ".
  "bibtexAuthor, bibtexYear, bibtexTitle, bibtexEditor, bibtexBooktitle, localUrlpdf, localUrlps, ".
  $match_string. " AS score ".
  "FROM ".$p."publication ".
  "WHERE $match_string  > 0 ".
  "ORDER BY score DESC;";
  $result = db_query($db, $query_string);
}
else
{
  $p = $config["ddDBPrefix"];
  $match_string = "(MATCH ".$p."comment.commentText AGAINST ('".$basic_text."'))";
  $query_string = "SELECT ".
    $p."publication.`key` as `key`, ".
    $p."publication.bibtexAuthor as bibtexAuthor, ".
    $p."publication.bibtexYear as bibtexYear, ".
    $p."publication.bibtexTitle as bibtexTitle, ".
    $p."publication.bibtexEditor as bibtexEditor, ".
    $p."publication.bibtexBooktitle as bibtexBooktitle, ".
    $p."publication.localUrlpdf as localUrlpdf, ".
    $p."publication.localUrlps as localUrlps, ".
    $p."publication.hasSummary as hasSummary, ".
    $match_string." AS score ".
    "FROM ".$p."publication, ".$p."comment ".
    "WHERE ".$p."publication.`key` = ".$p."comment.paperKey ".
    "AND ".$match_string." > 0 ".
    "ORDER BY score DESC ".
    "LIMIT ".$config["limitResultsFullText"].";";
  $result = db_query($db, $query_string);
  echo $query;
}
if (!$result)
{
  echo _("No result; maybe an error, see below if MySQL says something.");
  echo db_error($db);
  exit();
}

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Results (full text search)");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Results (full text search)");?></h1>
<p><?php echo db_num_rows($result); ?> <?php echo _("paper(s) matching the query");?> <tt><?php echo $basic_text; ?></tt>.</p>
<!--a-->
<ul class="paperbullet" id="full-text-results">
<?php
while ($row = db_fetch_assoc_array($result))
{
  if ($row["localUrlpdf"] || $row["localUrlps"])
  {
    echo "<li class=\"paperbullet\">\n";
  }
  else
  {
    echo "<li class=\"paperbullethollow\">\n";
  }
  $the_color = min(255, round((sqrt($row["score"])/sqrt(2))*255, 0));
  $string_the_color = ($the_color < 10 ? "0".dechex($the_color) : dechex($the_color));
  echo "<div class=\"score\" title=\""._("Match closeness score")."\">[<span style=\"color:#".$string_the_color."0000\">".number_format($row["score"], 2)."</span>]</div> ";
  $entry = format_paper_entry($db, $row, PRESENTATION_REGULAR);
  $entry = str_replace("?key=", "?full-text-query=".urlencode($basic_text)."&amp;key=", $entry);
  echo "<div class=\"result\">".$entry."</div>\n";
}
?>
</ul>
<!--z-->
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-12";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
