<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die(_("No paper key passed to the page."));
}

// Shows page header
$theme["page-title"] = _("Journal details");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Journal details");?></h1>

<p><?php echo _("This page is populated by collating paper entries with the same journal name.");?></p>

<table class="details" cellpadding="5" cellspacing="0">
<?php

// Additional conditions
$condition = "";
if (isset($_GET["volume"]))
{
  $condition .= " AND bibtexVolume = ".$_GET["volume"];
}
if (isset($_GET["number"]))
{
  $condition .= " AND bibtexNumber = ".$_GET["number"];
}

// Fetches *one* record from the DB (just to display details)
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE TRIM(bibtexJournal) = '".urldecode($_GET["key"])."' ".$condition." ORDER BY bibtexYear, bibtexVolume, bibtexNumber, bibtexPages LIMIT 1;");
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}
$row = db_fetch_assoc_array($result);
$count = 0;
$modulo = 2;
$out = "";
if ($row["bibtexJournal"] != "")
{
  $out .= "<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\""._("Journal title.")."\">"._("Journal title")."</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"journal?key=".$_GET["key"]."\">".htmlentities(db_decode($row["bibtexJournal"]))."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexISSN"] != "")
{
  $out .= "<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\""._("ISSN.")."\">"._("ISSN")."</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["ISSN"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
echo $out;
?>
</tr>
</table>

<?php
// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE TRIM(bibtexJournal) = '".urldecode($_GET["key"])."' ".$condition." ORDER BY bibtexYear, bibtexVolume, bibtexNumber, bibtexPages;");
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}

// Checks if paper is cross-referenced by other papers, and gives the list
echo "<dl class=\"bookbullet\">\n";
$gotta_close = false;
$current_number = -1;
$current_volume = -1;
while ($row = db_fetch_assoc_array($result))
{
  if ($row["bibtexVolume"] != $current_volume || $row["bibtexNumber"] != $current_number)
  {
    if ($gotta_close)
    {
      echo "</ul>\n</dd>\n";
    }
    $current_volume = $row["bibtexVolume"];
    $current_number = $row["bibtexNumber"];
    echo "<dt class=\"bookbullet\">";
    echo _("Volume")." ";
    echo "<a href=\"journal?key=".$_GET["key"]."&amp;volume=".$row["bibtexVolume"]."\">";
    echo $row["bibtexVolume"]."</a>, ";
    echo _("number")." ";
    echo "<a href=\"journal?key=".$_GET["key"]."&amp;volume=".$row["bibtexVolume"]."&amp;number=".$row["bibtexNumber"]."\">";
    echo $row["bibtexNumber"]."</a> ";
    echo "(".$row["bibtexYear"].")</dt>\n";
    echo "<dd>";
    echo "<ul class=\"paperbullet\">";
    $gotta_close = true;
  }
  // Prints the journal article
  echo "<li class=\"paperbullet\">";
  echo format_paper_entry($db, $row, PRESENTATION_ABRIDGED2);
  echo "</li>\n";
}
if ($gotta_close)
  echo "</ul>\n</dd>\n";
echo "</dl>\n";

// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-13";
show_theme_part("page-lower-body");
?>
