<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

/**
 * Determines the co-authors of an author
 * @param $author_fullname The name of the author
 * @param $parameters An optional associative array of parameters.  Currently
 *   the supported parameters are:
 *     exclude-misc:  set to true to exclude papers of type "misc" from the results
 *     exclude-techreport:  idem for techreport type
 * @return A list of two associative arrays:
 *   one of the form author name => number of co-authored papers
 *   one of the form author name => author key
 */
function getCoAuthors($author_fullname, $parameters = array()) // {{{
{
  global $config;
  global $db;
  $collaborations = array();
  $keys = array();
  $author_name = "CONCAT_WS(' ', IF(a1.firstName <> '', a1.firstName, NULL), IF(a1.vonPart <> '', a1.vonPart, NULL), IF(a1.lastName <> '', a1.lastName, NULL), IF(a1.jrPart <> '', a1.jrPart, NULL))";
  $query_string = "SELECT a1.authorKey, $author_name as authorname FROM ".$config["ddDBPrefix"]."author AS a1, ".$config["ddDBPrefix"]."publication as p1 WHERE p1.bibtexAuthor LIKE '%$author_fullname%' AND p1.bibtexAuthor LIKE CONCAT('%', $author_name, '%') AND $author_name NOT LIKE '$author_fullname'";
  if (isset($parameters["exclude-misc"]) && $parameters["exclude-misc"] === true)
  {
    $query_string .= " AND p1.typeBibtex <> 'misc'";
  }
  if (isset($parameters["exclude-techreport"]) && $parameters["exclude-techreport"] === true)
  {
    $query_string .= " AND p1.typeBibtex <> 'techreport'";
  }
  if (!$result = db_query($db, $query_string))
  {
    return $collaborations;
  }
  while($row = db_fetch_assoc_array($result))
  {
    if (!isset($collaborations[$row["authorname"]])) // If not not already there
    {
      $collaborations[$row["authorname"]] = 1;
      $keys[$row["authorname"]] = $row["authorKey"];
    }
    else
    {
      $collaborations[$row["authorname"]]++;
    }
  }
  return array($collaborations, $keys);
} // }}}


/**
 * Determines the co-authors of an author
 * @param $author_fullname The name of the author
 * @return An list of two associative arrays:
 *   one of the form author name => number of co-authored papers
 *   one of the form author name => author key
 */
function getCitees($author_fullname) // {{{
{
  global $config;
  global $db;
  $citees = array();
  $num_citations = array();
  $num_self_citations = array();
  $author_name = "CONCAT_WS(' ', IF(a1.firstName <> '', a1.firstName, NULL), IF(a1.vonPart <> '', a1.vonPart, NULL), IF(a1.lastName <> '', a1.lastName, NULL), IF(a1.jrPart <> '', a1.jrPart, NULL))";
  $query_string = "SELECT p1.bibtexAuthor AS authorsource, c1.source, c1.destination,
    p2.bibtexAuthor AS authordestination,
    $author_name AS authorname,
    a1.authorKey AS authorkey
    FROM "
    .$config["ddDBPrefix"]."publication as p1, "
    .$config["ddDBPrefix"]."publication as p2, "
    .$config["ddDBPrefix"]."author as a1, "
    .$config["ddDBPrefix"]."citation as c1 
    WHERE 
    p1.bibtexAuthor LIKE '%$author_fullname%' AND 
    p1.identifierBibtex = c1.source AND 
    c1.destination = p2.identifierBibtex AND 
    p2.bibtexAuthor LIKE CONCAT('%', $author_name, '%');";
  if (!$result = db_query($db, $query_string))
  {
    die(db_error($db));
    return $citees;
  }
  while($row = db_fetch_assoc_array($result))
  {
    $citees[$row["authorname"]] = $row["authorkey"];
    if (!isset($num_citations[$row["authorname"]]))
      $num_citations[$row["authorname"]] = 0;
    $num_citations[$row["authorname"]]++;
    if (strpos($row["authorsource"], $row["authorname"]) !== FALSE)
    {
      // This is a self-citation:  the author cited is among the authors of the source
      if (!isset($num_self_citations[$row["authorname"]]))
        $num_self_citations[$row["authorname"]] = 0;
      $num_self_citations[$row["authorname"]]++;
    }
    $citees[$row["authorname"]] = $row["authorkey"];
  }
  return array($citees, $num_citations, $num_self_citations);
} // }}}

// :folding=explicit:
?>
