<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

/**
 * Loads configuration file
 */
require_once("config.inc.php");

/**
 * Determines actual path to file
 */
$dadrill_path = dirname(__FILE__);
$prefix = realpath($dadrill_path . "/../");

/**
 * Turns magic quotes off
 */
@set_magic_quotes_runtime(0);

/**
 * I18N support information.  This part is taken from:
 * http://mel.melaxis.com/devblog/2005/08/06/localizing-php-web-sites-using-gettext/
 */
// If we have gettext
if (function_exists('bindtextdomain'))
{
  $locale = $config["language"];
  if (isset($_GET["locale"])) $locale = $_GET["locale"];
  putenv("LC_ALL=$locale");
  setlocale(LC_ALL, $locale);
  bindtextdomain("messages", "./locale");
  textdomain("messages");
}

/**
 * Disables display of notice messages (in a production context)
 */
error_reporting(E_ALL ^ E_NOTICE);

// Imports
require_once("lib/db-connection.lib.php");  // Connection info to the database
require_once("lib/db-queries.lib.php");  // Useful functions for parsing the DB
require_once("lib/encode-decode.lib.php");  // Encoding/decoding of strings
require_once("lib/entry-format.lib.php");   // Formatting of entries
require_once("lib/get-to-post.lib.php");   // Formatting of entries
require_once("lib/markdown.lib.php");           // Formatting of text comments
require_once("lib/presentation.lib.php");           // Functions for presentation purposes
require_once("lib/server.lib.php");    // Server functions
require_once("lib/string-categories.lib.php");    // Enhanced category management
require_once("lib/themes.lib.php");    // Management of display layouts

// If login is needed to access system, checks that user is actually logged
if ($config["mustLogin"])
  require_once("lib/session.lib.php");

// Connects to the database
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}
// :folding=explicit:wrap=none:
?>
