<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

/**
 * Creates a color gradient from an interval of numbers and returns the
 * hexadecimal RGB color code corresponding to a specific value in that
 * interval.
 * @param $value The value to map a color to.  If the value is outside the
 *   bounds of the interval min-max, it is cut to the value in the interval
 *   that is nearest to it (either min or max).
 * @param $min The minimum value of the range
 * @param $max The maximum value of the range
 * @param $parameters An array of parameters for the gradient
 * @return The color code.  If any of the colors mentioned in the parameters
 *   array start with the hash sign, the returned color will also start with
 *   the hash sign.
 */
function gradient($value, $min, $max, $parameters = array()) // {{{
{
  // Makes sure the value is inside the interval
  $value = max($value, $min);
  $value = min($value, $max);
  $color_value = array();
  
  // Whether or not to show the hash sign
  $show_hash = false;
  
  // Gradient style
  if (!is_array($parameters))
  {
    $gradient_style = 0;
  }
  else
  {
    $gradient_style = $parameters["style"];
    if (substr($parameters["start"], 0, 1) === "#")
    {
      $parameters["start"] = str_replace("#", "", $parameters["start"]);
      $show_hash = true;
    }
    if (substr($parameters["finish"], 0, 1) === "#")
    {
      $parameters["finish"] = str_replace("#", "", $parameters["finish"]);
      $show_hash = true;
    }
  }
  // Produces the color code
  switch ($gradient_style)
  {
    case "linear":
      $color_start["r"] = hexdec(substr($parameters["start"], 0, 2));
      $color_start["g"] = hexdec(substr($parameters["start"], 2, 2));
      $color_start["b"] = hexdec(substr($parameters["start"], 4, 2));
      $color_finish["r"] = hexdec(substr($parameters["finish"], 0, 2));
      $color_finish["g"] = hexdec(substr($parameters["finish"], 2, 2));
      $color_finish["b"] = hexdec(substr($parameters["finish"], 4, 2));
      $color_value["r"] = (($value - $min) / ($max - $min)) * ($color_finish["r"] - $color_start["r"]) + $color_start["r"];
      $color_value["g"] = (($value - $min) / ($max - $min)) * ($color_finish["g"] - $color_start["g"]) + $color_start["g"];
      $color_value["b"] = (($value - $min) / ($max - $min)) * ($color_finish["b"] - $color_start["b"]) + $color_start["b"];
      break;
    default:
      // The default is everything white (!)
      return "FFFFFF";
      break;
  }
  return ($show_hash ? "#" : "").sprintf("%02x%02x%02x", $color_value["r"], $color_value["g"], $color_value["b"]);
} // }}}

// :folding=explicit:wrap=none:
?>
