<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

$errors = 0;
$papers = array();
$papercount = 0;

// Formats category string
// NOTE: pattern has to escape category separator since it is a "/"
// This might change if you change category separator!
$category_string = preg_replace("/\\".CAT_SEPARATOR."\\s+/", CAT_SEPARATOR, trim($_POST["categoryPath"]));

// Updates the database
$result = db_query($db, "INSERT INTO ".$config["ddDBPrefix"]."publication SET "
  ." ownerLogin = ".((trim($_SESSION["username"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_SESSION["username"]))."', ")
  ." identifierBibtex = ".((trim($_POST["identifierBibtex"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["identifierBibtex"]))."', ")
  ." bibtexAddress = ".((trim($_POST["bibtexAddress"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAddress"]))."', ")
  ." bibtexAffiliation = ".((trim($_POST["bibtexAffiliation"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAffiliation"]))."', ")
  ." bibtexAnnote = ".((trim($_POST["bibtexAnnote"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAnnote"]))."', ")
  ." bibtexAuthor = ".((trim($_POST["bibtexAuthor"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAuthor"]))."', ")
  ." bibtexBibsource = ".((trim($_POST["bibtexBibsource"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexBibsource"]))."', ")
  ." bibtexBooktitle = ".((trim($_POST["bibtexBooktitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexBooktitle"]))."', ")
  ." bibtexChapter = ".((trim($_POST["bibtexChapter"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexChapter"]))."', ")
  ." bibtexCrossref = ".((trim($_POST["bibtexCrossref"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexCrossref"]))."', ")
  ." bibtexCopyright = ".((trim($_POST["bibtexCopyright"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexCopyright"]))."', ")
  ." bibtexEdition = ".((trim($_POST["bibtexEdition"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEdition"]))."', ")
  ." bibtexEditor = ".((trim($_POST["bibtexEditor"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEditor"]))."', ")
  ." bibtexEe = ".((trim($_POST["bibtexEe"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEe"]))."', ")
  ." bibtexHowpublished = ".((trim($_POST["bibtexHowpublished"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexHowpublished"]))."', ")
  ." bibtexInstitution = ".((trim($_POST["bibtexInstitution"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexInstitution"]))."', ")
  ." bibtexIsbn = ".((trim($_POST["bibtexIsbn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexIsbn"]))."', ")
  ." bibtexIssn = ".((trim($_POST["bibtexIssn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexIssn"]))."', ")
  ." bibtexJournal = ".((trim($_POST["bibtexJournal"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexJournal"]))."', ")
  ." bibtexKey = ".((trim($_POST["bibtexKey"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexKey"]))."', ")
  ." bibtexKeywords = ".((trim($_POST["bibtexKeywords"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexKeywords"]))."', ")
  ." bibtexLanguage = ".((trim($_POST["bibtexLanguage"]) == "") ? "'english', " : "'".db_encode(latex2utf($_POST["bibtexLanguage"]))."', ")
  ." bibtexLccn = ".((trim($_POST["bibtexLccn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexLccn"]))."', ")
  ." bibtexLocation = ".((trim($_POST["bibtexLocation"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexLocation"]))."', ")
  ." bibtexMonth = ".((trim($_POST["bibtexMonth"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexMonth"]))."', ")
  ." bibtexNumber = ".((trim($_POST["bibtexNumber"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexNumber"]))."', ")
  ." bibtexOrganization = ".((trim($_POST["bibtexOrganization"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexOrganization"]))."', ")
  ." bibtexPages = ".((trim($_POST["bibtexPages"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPages"]))."', ")
  ." bibtexPrice = ".((trim($_POST["bibtexPrice"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPrice"]))."', ")
  ." bibtexPublisher = ".((trim($_POST["bibtexPublisher"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPublisher"]))."', ")
  ." bibtexSchool = ".((trim($_POST["bibtexSchool"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSchool"]))."', ")
  ." bibtexSeries = ".((trim($_POST["bibtexSeries"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSeries"]))."', ")
  ." bibtexSize = ".((trim($_POST["bibtexSize"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSize"]))."', ")
  ." bibtexTitle = ".((trim($_POST["bibtexTitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexTitle"]))."', ")
  ." bibtexType = ".((trim($_POST["bibtexType"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexType"]))."', ")
  ." bibtexYear = ".((trim($_POST["bibtexYear"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexYear"]))."', ")
  ." bibtexUrl = ".((trim($_POST["bibtexUrl"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexUrl"]))."', ")
  ." bibtexAbstract = ".((trim($_POST["bibtexAbstract"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAbstract"]))."', ")
  ." bibtexContents = ".((trim($_POST["bibtexContents"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexContents"]))."', ")
  ." bibtexNote = ".((trim($_POST["bibtexNote"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexNote"]))."', ")
  ." categoryPath = ".(($category_string == "") ? "'".CAT_PATH."', " : "'".db_encode(latex2utf($category_string))."', ")
  ." fullpapertext = ".((trim($_POST["fullpapertext"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["fullpapertext"]))."', ")
  // Encodes local URLs twice, since escaped characters must remain escaped in the decoded URL
  ." localUrlpdf = ".((trim($_POST["localUrlpdf"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["localUrlpdf"]))."', ")
  ." localUrlps = ".((trim($_POST["localUrlps"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["localUrlps"]))."', ")
  ." insertionDate = '".date("Y-m-d")."', "
  ." insertionTime = '".date("H:i:s")."', "
  ." typeBibtex = '".$_POST["typeBibtex"]."';");
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  $errorstring = db_error($db);
  $errors = 1;
}
else
{
  $papers[$papercount] = db_encode(latex2utf($_POST["identifierBibtex"]));
  $papercount++;
}

// Checks whether the "auto-add authors" has been checked
if ($_POST["autoadd"] && $_POST["autoadd"] == "1")
{
  $authoradd = 0;
  $authormerge = 0;
  // Adds authors, if the author field is present
  if ($_POST["bibtexAuthor"])
  {
    $authors = explode(" and ", $_POST["bibtexAuthor"]);
    for ($i = 0; $i < count($authors); $i++)
    {
      $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."author WHERE TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))) = '".db_encode(latex2utf(trim($authors[$i])))."';");
      if (!$result)
        echo db_error($db);
      $row2 = db_fetch_assoc_array($result);
      if ($row2)
      {
        // This author is in the database
        $authormerge++;
      }
      else
      {
        // This author is not in the database: add it
        $exploded_name = explode_author_name(trim($authors[$i]));
        $result = db_query($db, "INSERT INTO ".$config["ddDBPrefix"]."author SET firstName = '".db_encode(latex2utf($exploded_name[0]))."', vonPart = '".db_encode(latex2utf($exploded_name[1]))."', lastName = '".db_encode(latex2utf($exploded_name[2]))."', jrPart = '".db_encode(latex2utf($exploded_name[3]))."';");
        if (!$result)
          echo db_error($db);
        $authoradd++;
      }
    }
  }
}
// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Summary of addition");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Summary of addition");?></h1>
<p><?php echo $papercount - 1; ?> <?php echo _("entry added out of ");?> 1:</p>

<?php
if ($papercount > 1)
  echo "<ul class=\"paperbullet\">\n";
foreach ($papers as $key)
{
  // Gets BibTeX identifier of newly added paper
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE identifierBibtex LIKE '".db_encode(latex2utf($key))."';");
  if (!$result)
    echo db_error($db);
  $row = db_fetch_assoc_array($result);
  echo "<li class=\"paperbullethollow\">".format_paper_entry($db, $row, PRESENTATION_REGULAR)."</li>\n";
}
if ($papercount > 1)
  echo "</ul>\n";
?>

<?php if ($_POST["autoadd"] == "1" && (1 - $errors > 0)) { ?>
<p><?php echo _("Auto-add authors selected:");?>  
<?php  if ($_POST["bibtexAuthor"]) { ?>
<?php echo $authormerge; ?> <?php echo _("author(s) merged and");?>
<?php echo $authoradd; ?> <?php echo _("new author(s) added.");?>
<?php } else { ?>
<?php echo _("no <i>Author</i> field found in the entry.");?>
<?php } ?>
</p>
<?php } ?>
<?php
if ($errors > 0)
{
  echo "<p>"._("Error messages").":</p>\n";
  echo "<ul>\n".$errorstring."</ul>";
}
?>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
